/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.advice;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class Xs2aRestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(Xs2aRestExceptionHandler.class);
    private final ErrorMapperContainer errorMapperContainer;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;
    private final Xs2aObjectMapper xs2aObjectMapper;

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String responseStringWithError = "";
        try {
            responseStringWithError = this.xs2aObjectMapper.writeValueAsString(this.createError(ex.getMethod()));
        }
        catch (JsonProcessingException e) {
            log.warn("Can't convert object to json: {}", (Object)e.getMessage());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).contentType(MediaType.APPLICATION_JSON).body((Object)responseStringWithError);
    }

    private Object createError(String methodName) {
        MessageError messageError = new MessageError(this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.SERVICE_INVALID_405.getCode()), this.buildErrorTppMessages(methodName));
        return this.errorMapperContainer.getErrorBody(messageError).getBody();
    }

    private TppMessageInformation buildErrorTppMessages(String methodName) {
        return TppMessageInformation.of(MessageErrorCode.SERVICE_INVALID_405_METHOD_NOT_SUPPORTED, methodName);
    }

    @ConstructorProperties(value={"errorMapperContainer", "serviceTypeDiscoveryService", "errorTypeMapper", "xs2aObjectMapper"})
    public Xs2aRestExceptionHandler(ErrorMapperContainer errorMapperContainer, ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper, Xs2aObjectMapper xs2aObjectMapper) {
        this.errorMapperContainer = errorMapperContainer;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

