/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountBalanceRequestObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetBalancesReportValidator
extends AbstractAccountTppValidator<CommonAccountBalanceRequestObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CommonAccountBalanceRequestObject consentObject) {
        AccountConsent accountConsent = consentObject.getAccountConsent();
        Xs2aAccountAccess accountAccess = accountConsent.getAspspAccess();
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(accountAccess, accountAccess.getBalances(), consentObject.getAccountId(), accountConsent.getAisConsentRequestType());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        return this.accountConsentValidator.validate(accountConsent, consentObject.getRequestUri());
    }

    @ConstructorProperties(value={"accountConsentValidator", "accountReferenceAccessValidator"})
    public GetBalancesReportValidator(AccountConsentValidator accountConsentValidator, AccountReferenceAccessValidator accountReferenceAccessValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
    }
}

