/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppDomainValidator;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class TppUriHeaderValidator
implements BusinessValidator<TppRedirectUri> {
    private final TppDomainValidator tppDomainValidator;
    private final ScaApproachResolver scaApproachResolver;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull TppRedirectUri tppRedirectUri) {
        return ValidationResult.valid();
    }

    @Override
    @NotNull
    public Set<TppMessageInformation> buildWarningMessages(@NotNull TppRedirectUri tppRedirectUri) {
        HashSet<TppMessageInformation> warnings = new HashSet<TppMessageInformation>();
        if (this.isRedirectScaApproach()) {
            warnings.addAll(this.tppDomainValidator.buildWarningMessages(tppRedirectUri.getUri()));
            if (tppRedirectUri.getNokUri() != null) {
                warnings.addAll(this.tppDomainValidator.buildWarningMessages(tppRedirectUri.getNokUri()));
            }
        }
        return warnings;
    }

    private boolean isRedirectScaApproach() {
        return ScaApproach.REDIRECT == this.scaApproachResolver.resolveScaApproach();
    }

    @ConstructorProperties(value={"tppDomainValidator", "scaApproachResolver"})
    public TppUriHeaderValidator(TppDomainValidator tppDomainValidator, ScaApproachResolver scaApproachResolver) {
        this.tppDomainValidator = tppDomainValidator;
        this.scaApproachResolver = scaApproachResolver;
    }
}

