/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.read;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.service.payment.read.AbstractReadPaymentService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bulk-payments")
public class ReadBulkPaymentService
extends AbstractReadPaymentService {
    private BulkPaymentSpi bulkPaymentSpi;
    private SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper;

    @Autowired
    public ReadBulkPaymentService(BulkPaymentSpi bulkPaymentSpi, SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper, SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, RequestProviderService requestProviderService, Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService, SpiContextDataProvider spiContextDataProvider, SpiPaymentFactory spiPaymentFactory) {
        super(spiErrorMapper, aspspConsentDataProviderFactory, requestProviderService, updatePaymentStatusAfterSpiService, spiContextDataProvider, spiPaymentFactory);
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.spiToXs2aBulkPaymentMapper = spiToXs2aBulkPaymentMapper;
    }

    @Override
    public Optional<SpiBulkPayment> createSpiPayment(List<PisPayment> pisPayments, String paymentProduct) {
        return this.spiPaymentFactory.createSpiBulkPayment(pisPayments, paymentProduct);
    }

    public SpiResponse<SpiBulkPayment> getSpiPaymentById(SpiContextData spiContextData, Object spiPayment, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.bulkPaymentSpi.getPaymentById(spiContextData, (SpiBulkPayment)spiPayment, aspspConsentDataProvider);
    }

    @Override
    public CommonPayment getXs2aPayment(SpiResponse spiResponse) {
        SpiBulkPayment spiBulkPayment = (SpiBulkPayment)spiResponse.getPayload();
        return this.spiToXs2aBulkPaymentMapper.mapToXs2aBulkPayment(spiBulkPayment);
    }
}

