/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.create;

import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aToCmsPisCommonPaymentRequestMapper;
import de.adorsys.psd2.xs2a.service.payment.create.AbstractCreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.create.spi.BulkPaymentInitiationService;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateBulkPaymentService
extends AbstractCreatePaymentService<BulkPayment, BulkPaymentInitiationService> {
    @Autowired
    public CreateBulkPaymentService(Xs2aPisCommonPaymentService pisCommonPaymentService, PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver, AuthorisationMethodDecider authorisationMethodDecider, Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper, Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper, BulkPaymentInitiationService paymentInitiationService, RequestProviderService requestProviderService) {
        super(pisCommonPaymentService, pisScaAuthorisationServiceResolver, authorisationMethodDecider, xs2aPisCommonPaymentMapper, xs2aToCmsPisCommonPaymentRequestMapper, paymentInitiationService, requestProviderService);
    }

    @Override
    protected BulkPayment getPaymentRequest(Object payment, PaymentInitiationParameters paymentInitiationParameters) {
        return (BulkPayment)payment;
    }

    @Override
    protected BulkPayment updateCommonPayment(BulkPayment paymentRequest, PaymentInitiationParameters paymentInitiationParameters, PaymentInitiationResponse response, String paymentId) {
        paymentRequest.getPayments().forEach(p -> p.setPaymentId(UUID.randomUUID().toString()));
        this.pisCommonPaymentService.updateBulkPaymentInCommonPayment(paymentRequest, paymentInitiationParameters, paymentId);
        return paymentRequest;
    }
}

