/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.cancel;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.payment.cancel.CancelPaymentService;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractCancelPaymentService
implements CancelPaymentService {
    private final de.adorsys.psd2.xs2a.service.payment.CancelPaymentService cancelPaymentService;

    @Override
    public ResponseObject<CancelPaymentResponse> cancelPayment(CommonPaymentData commonPaymentData, PisPaymentCancellationRequest paymentCancellationRequest) {
        List<PisPayment> pisPayments = this.getPisPayments(commonPaymentData);
        if (!this.isCommonPayment() && CollectionUtils.isEmpty(pisPayments)) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        Optional<? extends SpiPayment> spiPaymentOptional = this.createSpiPayment(pisPayments, commonPaymentData);
        if (!spiPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        return this.cancelPaymentService.initiatePaymentCancellation(spiPaymentOptional.get(), paymentCancellationRequest.getEncryptedPaymentId(), paymentCancellationRequest.getTppExplicitAuthorisationPreferred(), paymentCancellationRequest.getTppRedirectUri());
    }

    protected abstract Optional<? extends SpiPayment> createSpiPayment(List<PisPayment> var1, CommonPaymentData var2);

    protected boolean isCommonPayment() {
        return false;
    }

    private List<PisPayment> getPisPayments(CommonPaymentData commonPaymentData) {
        List pisPayments = Optional.of(commonPaymentData).map(CommonPaymentData::getPayments).orElseGet(Collections::emptyList);
        pisPayments.forEach(pmt -> {
            pmt.setPaymentId(commonPaymentData.getExternalId());
            pmt.setTransactionStatus(commonPaymentData.getTransactionStatus());
            pmt.setPsuDataList(commonPaymentData.getPsuData());
            pmt.setStatusChangeTimestamp(commonPaymentData.getStatusChangeTimestamp());
        });
        return pisPayments;
    }

    @ConstructorProperties(value={"cancelPaymentService"})
    public AbstractCancelPaymentService(de.adorsys.psd2.xs2a.service.payment.CancelPaymentService cancelPaymentService) {
        this.cancelPaymentService = cancelPaymentService;
    }
}

