/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiServiceEncrypted;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.service.context.LoggingContextService;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class Xs2aUpdatePaymentAfterSpiService {
    private final UpdatePaymentAfterSpiServiceEncrypted updatePaymentStatusAfterSpiService;
    private final LoggingContextService loggingContextService;

    public boolean updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status) {
        boolean statusUpdated = this.updatePaymentStatusAfterSpiService.updatePaymentStatus(paymentId, status);
        if (statusUpdated) {
            this.loggingContextService.storeTransactionStatus(status);
        }
        return statusUpdated;
    }

    public boolean updatePaymentCancellationTppRedirectUri(@NotNull String paymentId, @NotNull TppRedirectUri tppRedirectUri) {
        return this.updatePaymentStatusAfterSpiService.updatePaymentCancellationTppRedirectUri(paymentId, tppRedirectUri);
    }

    public boolean updatePaymentCancellationInternalRequestId(@NotNull String paymentId, @NotNull String internalRequestId) {
        return this.updatePaymentStatusAfterSpiService.updatePaymentCancellationInternalRequestId(paymentId, internalRequestId);
    }

    @ConstructorProperties(value={"updatePaymentStatusAfterSpiService", "loggingContextService"})
    public Xs2aUpdatePaymentAfterSpiService(UpdatePaymentAfterSpiServiceEncrypted updatePaymentStatusAfterSpiService, LoggingContextService loggingContextService) {
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.loggingContextService = loggingContextService;
    }
}

