/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.exception.model.error500.Error500NGSB;
import de.adorsys.psd2.xs2a.exception.model.error500.TppMessage500SB;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB500ErrorMapper
extends Psd2ErrorMapper<MessageError, Error500NGSB> {
    @Override
    public Function<MessageError, Error500NGSB> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private Error500NGSB mapToPsd2Error(MessageError messageError) {
        return new Error500NGSB().tppMessages(this.mapToTppMessage500SB(messageError.getTppMessages()));
    }

    private List<TppMessage500SB> mapToTppMessage500SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage500SB().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(m.getMessageErrorCode().getName()).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

