/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public final class Xs2aAccountAccess {
    private final List<AccountReference> accounts;
    private final List<AccountReference> balances;
    private final List<AccountReference> transactions;
    private final AccountAccessType availableAccounts;
    private final AccountAccessType allPsd2;
    private final AccountAccessType availableAccountsWithBalance;

    @JsonIgnore
    public boolean isNotEmpty() {
        return !CollectionUtils.isEmpty(this.accounts) || !CollectionUtils.isEmpty(this.balances) || !CollectionUtils.isEmpty(this.transactions) || this.allPsd2 != null || this.availableAccounts != null || this.availableAccountsWithBalance != null;
    }

    @ConstructorProperties(value={"accounts", "balances", "transactions", "availableAccounts", "allPsd2", "availableAccountsWithBalance"})
    public Xs2aAccountAccess(List<AccountReference> accounts, List<AccountReference> balances, List<AccountReference> transactions, AccountAccessType availableAccounts, AccountAccessType allPsd2, AccountAccessType availableAccountsWithBalance) {
        this.accounts = accounts;
        this.balances = balances;
        this.transactions = transactions;
        this.availableAccounts = availableAccounts;
        this.allPsd2 = allPsd2;
        this.availableAccountsWithBalance = availableAccountsWithBalance;
    }

    public List<AccountReference> getAccounts() {
        return this.accounts;
    }

    public List<AccountReference> getBalances() {
        return this.balances;
    }

    public List<AccountReference> getTransactions() {
        return this.transactions;
    }

    public AccountAccessType getAvailableAccounts() {
        return this.availableAccounts;
    }

    public AccountAccessType getAllPsd2() {
        return this.allPsd2;
    }

    public AccountAccessType getAvailableAccountsWithBalance() {
        return this.availableAccountsWithBalance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xs2aAccountAccess)) {
            return false;
        }
        Xs2aAccountAccess other = (Xs2aAccountAccess)o;
        List<AccountReference> this$accounts = this.getAccounts();
        List<AccountReference> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        List<AccountReference> this$balances = this.getBalances();
        List<AccountReference> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        List<AccountReference> this$transactions = this.getTransactions();
        List<AccountReference> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        AccountAccessType this$availableAccounts = this.getAvailableAccounts();
        AccountAccessType other$availableAccounts = other.getAvailableAccounts();
        if (this$availableAccounts == null ? other$availableAccounts != null : !this$availableAccounts.equals(other$availableAccounts)) {
            return false;
        }
        AccountAccessType this$allPsd2 = this.getAllPsd2();
        AccountAccessType other$allPsd2 = other.getAllPsd2();
        if (this$allPsd2 == null ? other$allPsd2 != null : !this$allPsd2.equals(other$allPsd2)) {
            return false;
        }
        AccountAccessType this$availableAccountsWithBalance = this.getAvailableAccountsWithBalance();
        AccountAccessType other$availableAccountsWithBalance = other.getAvailableAccountsWithBalance();
        return !(this$availableAccountsWithBalance == null ? other$availableAccountsWithBalance != null : !this$availableAccountsWithBalance.equals(other$availableAccountsWithBalance));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AccountReference> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        List<AccountReference> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        List<AccountReference> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        AccountAccessType $availableAccounts = this.getAvailableAccounts();
        result = result * 59 + ($availableAccounts == null ? 43 : $availableAccounts.hashCode());
        AccountAccessType $allPsd2 = this.getAllPsd2();
        result = result * 59 + ($allPsd2 == null ? 43 : $allPsd2.hashCode());
        AccountAccessType $availableAccountsWithBalance = this.getAvailableAccountsWithBalance();
        result = result * 59 + ($availableAccountsWithBalance == null ? 43 : $availableAccountsWithBalance.hashCode());
        return result;
    }

    public String toString() {
        return "Xs2aAccountAccess(accounts=" + this.getAccounts() + ", balances=" + this.getBalances() + ", transactions=" + this.getTransactions() + ", availableAccounts=" + this.getAvailableAccounts() + ", allPsd2=" + this.getAllPsd2() + ", availableAccountsWithBalance=" + this.getAvailableAccountsWithBalance() + ")";
    }
}

