/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountConsent {
    @JsonIgnore
    private final String id;
    private final Xs2aAccountAccess access;
    private final Xs2aAccountAccess aspspAccess;
    private final boolean recurringIndicator;
    private final LocalDate validUntil;
    private final LocalDate expireDate;
    private final int frequencyPerDay;
    private final LocalDate lastActionDate;
    private final ConsentStatus consentStatus;
    @JsonIgnore
    private final boolean withBalance;
    @JsonIgnore
    private final boolean tppRedirectPreferred;
    @JsonIgnore
    private final List<PsuIdData> psuIdDataList;
    @JsonIgnore
    private final TppInfo tppInfo;
    @JsonIgnore
    private final AisConsentRequestType aisConsentRequestType;
    private final boolean multilevelScaRequired;
    private final List<AccountConsentAuthorization> authorisations;
    private final OffsetDateTime statusChangeTimestamp;
    @JsonIgnore
    private Map<String, Integer> usageCounterMap = new HashMap<String, Integer>();

    @JsonIgnore
    public boolean isExpired() {
        return this.consentStatus == ConsentStatus.EXPIRED;
    }

    @JsonIgnore
    public boolean isOneAccessType() {
        return !this.recurringIndicator;
    }

    @JsonIgnore
    public boolean isConsentForAllAvailableAccounts() {
        return this.getAisConsentRequestType() == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
    }

    @JsonIgnore
    public boolean isConsentForDedicatedAccounts() {
        return this.getAisConsentRequestType() == AisConsentRequestType.DEDICATED_ACCOUNTS;
    }

    public Optional<AccountConsentAuthorization> findAuthorisationInConsent(String authorisationId) {
        return this.authorisations.stream().filter(auth -> auth.getId().equals(authorisationId)).findFirst();
    }

    public String getId() {
        return this.id;
    }

    public Xs2aAccountAccess getAccess() {
        return this.access;
    }

    public Xs2aAccountAccess getAspspAccess() {
        return this.aspspAccess;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public boolean isWithBalance() {
        return this.withBalance;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public List<PsuIdData> getPsuIdDataList() {
        return this.psuIdDataList;
    }

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    public AisConsentRequestType getAisConsentRequestType() {
        return this.aisConsentRequestType;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    public List<AccountConsentAuthorization> getAuthorisations() {
        return this.authorisations;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public Map<String, Integer> getUsageCounterMap() {
        return this.usageCounterMap;
    }

    public void setUsageCounterMap(Map<String, Integer> usageCounterMap) {
        this.usageCounterMap = usageCounterMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountConsent)) {
            return false;
        }
        AccountConsent other = (AccountConsent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Xs2aAccountAccess this$access = this.getAccess();
        Xs2aAccountAccess other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)this$access).equals(other$access)) {
            return false;
        }
        Xs2aAccountAccess this$aspspAccess = this.getAspspAccess();
        Xs2aAccountAccess other$aspspAccess = other.getAspspAccess();
        if (this$aspspAccess == null ? other$aspspAccess != null : !((Object)this$aspspAccess).equals(other$aspspAccess)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        LocalDate this$expireDate = this.getExpireDate();
        LocalDate other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        if (this.isWithBalance() != other.isWithBalance()) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        List<PsuIdData> this$psuIdDataList = this.getPsuIdDataList();
        List<PsuIdData> other$psuIdDataList = other.getPsuIdDataList();
        if (this$psuIdDataList == null ? other$psuIdDataList != null : !((Object)this$psuIdDataList).equals(other$psuIdDataList)) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        AisConsentRequestType this$aisConsentRequestType = this.getAisConsentRequestType();
        AisConsentRequestType other$aisConsentRequestType = other.getAisConsentRequestType();
        if (this$aisConsentRequestType == null ? other$aisConsentRequestType != null : !this$aisConsentRequestType.equals(other$aisConsentRequestType)) {
            return false;
        }
        if (this.isMultilevelScaRequired() != other.isMultilevelScaRequired()) {
            return false;
        }
        List<AccountConsentAuthorization> this$authorisations = this.getAuthorisations();
        List<AccountConsentAuthorization> other$authorisations = other.getAuthorisations();
        if (this$authorisations == null ? other$authorisations != null : !((Object)this$authorisations).equals(other$authorisations)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        Map<String, Integer> this$usageCounterMap = this.getUsageCounterMap();
        Map<String, Integer> other$usageCounterMap = other.getUsageCounterMap();
        return !(this$usageCounterMap == null ? other$usageCounterMap != null : !((Object)this$usageCounterMap).equals(other$usageCounterMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountConsent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Xs2aAccountAccess $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)$access).hashCode());
        Xs2aAccountAccess $aspspAccess = this.getAspspAccess();
        result = result * 59 + ($aspspAccess == null ? 43 : ((Object)$aspspAccess).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        LocalDate $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        result = result * 59 + this.getFrequencyPerDay();
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        result = result * 59 + (this.isWithBalance() ? 79 : 97);
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        List<PsuIdData> $psuIdDataList = this.getPsuIdDataList();
        result = result * 59 + ($psuIdDataList == null ? 43 : ((Object)$psuIdDataList).hashCode());
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        AisConsentRequestType $aisConsentRequestType = this.getAisConsentRequestType();
        result = result * 59 + ($aisConsentRequestType == null ? 43 : $aisConsentRequestType.hashCode());
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        List<AccountConsentAuthorization> $authorisations = this.getAuthorisations();
        result = result * 59 + ($authorisations == null ? 43 : ((Object)$authorisations).hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        Map<String, Integer> $usageCounterMap = this.getUsageCounterMap();
        result = result * 59 + ($usageCounterMap == null ? 43 : ((Object)$usageCounterMap).hashCode());
        return result;
    }

    public String toString() {
        return "AccountConsent(id=" + this.getId() + ", access=" + this.getAccess() + ", aspspAccess=" + this.getAspspAccess() + ", recurringIndicator=" + this.isRecurringIndicator() + ", validUntil=" + this.getValidUntil() + ", expireDate=" + this.getExpireDate() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", lastActionDate=" + this.getLastActionDate() + ", consentStatus=" + this.getConsentStatus() + ", withBalance=" + this.isWithBalance() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", psuIdDataList=" + this.getPsuIdDataList() + ", tppInfo=" + this.getTppInfo() + ", aisConsentRequestType=" + this.getAisConsentRequestType() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ", authorisations=" + this.getAuthorisations() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", usageCounterMap=" + this.getUsageCounterMap() + ")";
    }

    @ConstructorProperties(value={"id", "access", "aspspAccess", "recurringIndicator", "validUntil", "expireDate", "frequencyPerDay", "lastActionDate", "consentStatus", "withBalance", "tppRedirectPreferred", "psuIdDataList", "tppInfo", "aisConsentRequestType", "multilevelScaRequired", "authorisations", "statusChangeTimestamp", "usageCounterMap"})
    public AccountConsent(String id, Xs2aAccountAccess access, Xs2aAccountAccess aspspAccess, boolean recurringIndicator, LocalDate validUntil, LocalDate expireDate, int frequencyPerDay, LocalDate lastActionDate, ConsentStatus consentStatus, boolean withBalance, boolean tppRedirectPreferred, List<PsuIdData> psuIdDataList, TppInfo tppInfo, AisConsentRequestType aisConsentRequestType, boolean multilevelScaRequired, List<AccountConsentAuthorization> authorisations, OffsetDateTime statusChangeTimestamp, Map<String, Integer> usageCounterMap) {
        this.id = id;
        this.access = access;
        this.aspspAccess = aspspAccess;
        this.recurringIndicator = recurringIndicator;
        this.validUntil = validUntil;
        this.expireDate = expireDate;
        this.frequencyPerDay = frequencyPerDay;
        this.lastActionDate = lastActionDate;
        this.consentStatus = consentStatus;
        this.withBalance = withBalance;
        this.tppRedirectPreferred = tppRedirectPreferred;
        this.psuIdDataList = psuIdDataList;
        this.tppInfo = tppInfo;
        this.aisConsentRequestType = aisConsentRequestType;
        this.multilevelScaRequired = multilevelScaRequired;
        this.authorisations = authorisations;
        this.statusChangeTimestamp = statusChangeTimestamp;
        this.usageCounterMap = usageCounterMap;
    }
}

