/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component.logger.request;

import de.adorsys.psd2.xs2a.component.MultiReadHttpServletRequest;
import de.adorsys.psd2.xs2a.component.MultiReadHttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.util.WebUtils;

public final class RequestResponseLogMessage {
    private final String message;

    public static RequestResponseLogMessageBuilder builder(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        return new RequestResponseLogMessageBuilder(request, response);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestResponseLogMessage)) {
            return false;
        }
        RequestResponseLogMessage other = (RequestResponseLogMessage)o;
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "RequestResponseLogMessage(message=" + this.getMessage() + ")";
    }

    @ConstructorProperties(value={"message"})
    private RequestResponseLogMessage(String message) {
        this.message = message;
    }

    public static class RequestResponseLogMessageBuilder {
        private static final String INTERNAL_REQUEST_ID = "InR-ID";
        private static final String URI = "uri";
        private static final String REQUEST_HEADERS = "requestHeaders";
        private static final String RESPONSE_HEADERS = "responseHeaders";
        private static final String PAYLOAD = "requestPayload";
        private static final String RESPONSE_STATUS = "responseStatus";
        private static final String RESPONSE_BODY = "responseBody";
        private static final String MULTIPART_FORM_DATA = "multipart/form-data";
        private static final String MULTIPART_VALUES_SEPARATOR = "&";
        private static final String QUERY_SEPARATOR = "?";
        private Map<String, String> logParams = new LinkedHashMap<String, String>();
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        private RequestResponseLogMessageBuilder(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public RequestResponseLogMessageBuilder withInternalRequestId(@NotNull UUID internalRequestId) {
            this.logParams.put(INTERNAL_REQUEST_ID, internalRequestId.toString());
            return this;
        }

        public RequestResponseLogMessageBuilder withRequestUri() {
            String uri = this.extractUri(this.request);
            this.logParams.put(URI, uri);
            return this;
        }

        public RequestResponseLogMessageBuilder withRequestHeaders() {
            Enumeration headerNames = this.request.getHeaderNames();
            if (headerNames != null) {
                String requestHeadersMessage = this.extractHeaders(Collections.list(headerNames), arg_0 -> ((HttpServletRequest)this.request).getHeader(arg_0));
                this.logParams.put(REQUEST_HEADERS, requestHeadersMessage);
            }
            return this;
        }

        public RequestResponseLogMessageBuilder withRequestPayload() {
            String contentType = this.request.getContentType();
            String payload = contentType != null && contentType.contains(MULTIPART_FORM_DATA) ? this.extractRequestParametersPayload(this.request) : this.extractRequestBody(this.request);
            if (payload != null) {
                this.logParams.put(PAYLOAD, payload);
            }
            return this;
        }

        public RequestResponseLogMessageBuilder withResponseStatus() {
            this.logParams.put(RESPONSE_STATUS, String.valueOf(this.response.getStatus()));
            return this;
        }

        public RequestResponseLogMessageBuilder withResponseHeaders() {
            String responseHeadersMessage = this.extractHeaders(this.response.getHeaderNames(), arg_0 -> ((HttpServletResponse)this.response).getHeader(arg_0));
            this.logParams.put(RESPONSE_HEADERS, responseHeadersMessage);
            return this;
        }

        public RequestResponseLogMessageBuilder withResponseBody() {
            String body = this.extractResponseBody(this.response);
            if (body != null) {
                this.logParams.put(RESPONSE_BODY, body);
            }
            return this;
        }

        public RequestResponseLogMessage build() {
            String logMessage = this.logParams.entrySet().stream().map(e -> (String)e.getKey() + ": [" + (String)e.getValue() + "]").collect(Collectors.joining(", "));
            return new RequestResponseLogMessage(logMessage);
        }

        private String extractUri(HttpServletRequest request) {
            String uri = request.getRequestURI();
            String queryString = request.getQueryString();
            if (queryString != null) {
                uri = uri + QUERY_SEPARATOR + queryString;
            }
            return uri;
        }

        @Nullable
        private String extractRequestBody(HttpServletRequest request) {
            MultiReadHttpServletRequest wrapper = (MultiReadHttpServletRequest)((Object)WebUtils.getNativeRequest((ServletRequest)request, MultiReadHttpServletRequest.class));
            if (wrapper != null) {
                try {
                    byte[] requestBytes = IOUtils.toByteArray((InputStream)wrapper.getInputStream());
                    return this.extractBody(requestBytes);
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        private String extractRequestParametersPayload(HttpServletRequest request) {
            Map requestParams = request.getParameterMap();
            return requestParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + String.join((CharSequence)MULTIPART_VALUES_SEPARATOR, (CharSequence[])e.getValue())).collect(Collectors.joining(MULTIPART_VALUES_SEPARATOR));
        }

        @Nullable
        private String extractResponseBody(HttpServletResponse response) {
            MultiReadHttpServletResponse wrapper = (MultiReadHttpServletResponse)((Object)WebUtils.getNativeResponse((ServletResponse)response, MultiReadHttpServletResponse.class));
            if (wrapper != null) {
                byte[] cachedContent = wrapper.getCachedContent();
                return this.extractBody(cachedContent);
            }
            return null;
        }

        private String extractHeaders(Collection<String> headerNames, Function<String, String> headerValueExtractor) {
            return headerNames.stream().map(header -> header + ": " + (String)headerValueExtractor.apply((String)header)).collect(Collectors.joining(", "));
        }

        private String extractBody(byte[] body) {
            return new String(body, StandardCharsets.UTF_8);
        }
    }
}

