/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.header.AbstractHeaderValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.header.account.TransactionListHeaderValidator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AcceptHeaderValidatorImpl
extends AbstractHeaderValidatorImpl
implements TransactionListHeaderValidator {
    @Autowired
    public AcceptHeaderValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getHeaderName() {
        return "Accept";
    }

    @Override
    public MessageError validate(Map<String, String> headers, MessageError messageError) {
        String header = headers.get(this.getHeaderName());
        if (Objects.nonNull(header) && StringUtils.isBlank((CharSequence)header)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_BLANK_HEADER, this.getHeaderName()));
        }
        return messageError;
    }
}

