/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.ObjectValidator;
import de.adorsys.psd2.xs2a.web.validator.body.CurrencyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.IbanValidator;
import de.adorsys.psd2.xs2a.web.validator.body.OptionalFieldMaxLengthValidator;
import de.adorsys.psd2.xs2a.web.validator.body.StringMaxLengthValidator;
import java.beans.ConstructorProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AccountReferenceValidator
implements ObjectValidator<AccountReference> {
    private final ErrorBuildingService errorBuildingService;
    private final OptionalFieldMaxLengthValidator optionalFieldMaxLengthValidator;
    private final CurrencyValidator currencyValidator;
    private final IbanValidator ibanValidator;

    @Override
    public void validate(@NotNull AccountReference accountReference, @NotNull MessageError messageError) {
        this.ibanValidator.validate(accountReference.getIban(), messageError);
        if (StringUtils.isNotBlank((CharSequence)accountReference.getBban()) && !this.isValidBban(accountReference.getBban())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_INVALID_FIELD, "BBAN"));
        }
        this.optionalFieldMaxLengthValidator.validate(new StringMaxLengthValidator.MaxLengthRequirement(accountReference.getPan(), "PAN", 35), messageError);
        this.optionalFieldMaxLengthValidator.validate(new StringMaxLengthValidator.MaxLengthRequirement(accountReference.getMaskedPan(), "Masked PAN", 35), messageError);
        this.optionalFieldMaxLengthValidator.validate(new StringMaxLengthValidator.MaxLengthRequirement(accountReference.getMsisdn(), "MSISDN", 35), messageError);
        if (Objects.nonNull(accountReference.getCurrency())) {
            this.currencyValidator.validateCurrency(accountReference.getCurrency(), messageError);
        }
    }

    private boolean isValidBban(String bban) {
        return this.normalizeString(bban).length() >= 11 && this.normalizeString(bban).length() <= 28;
    }

    private String normalizeString(String string) {
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }

    @ConstructorProperties(value={"errorBuildingService", "optionalFieldMaxLengthValidator", "currencyValidator", "ibanValidator"})
    public AccountReferenceValidator(ErrorBuildingService errorBuildingService, OptionalFieldMaxLengthValidator optionalFieldMaxLengthValidator, CurrencyValidator currencyValidator, IbanValidator ibanValidator) {
        this.errorBuildingService = errorBuildingService;
        this.optionalFieldMaxLengthValidator = optionalFieldMaxLengthValidator;
        this.currencyValidator = currencyValidator;
        this.ibanValidator = ibanValidator;
    }
}

