/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.psd2.xs2a.component.DayOfExecutionDeserializer;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.service.validator.ValueValidatorService;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapperXs2a {
    private static final Logger log = LoggerFactory.getLogger(PaymentModelMapperXs2a.class);
    private final ValueValidatorService validationService;
    private final HttpServletRequest httpServletRequest;
    private final Xs2aObjectMapper xs2aObjectMapper;
    private final PaymentModelMapper paymentModelMapper;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;

    public Object mapToXs2aPayment(Object payment, PaymentInitiationParameters requestParameters) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(requestParameters.getPaymentProduct())) {
            return this.buildBinaryBodyData(this.httpServletRequest);
        }
        if (requestParameters.getPaymentType() == PaymentType.SINGLE) {
            return this.paymentModelMapper.mapToXs2aPayment(this.validatePayment(payment, PaymentInitiationJson.class));
        }
        if (requestParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.paymentModelMapper.mapToXs2aPayment(this.validatePayment(payment, PeriodicPaymentInitiationJson.class));
        }
        return this.paymentModelMapper.mapToXs2aPayment(this.validatePayment(payment, BulkPaymentInitiationJson.class));
    }

    public Object mapToXs2aRawPayment(PaymentInitiationParameters requestParameters, Object xmlSct, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonStandingOrderType) {
        if (requestParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.buildPeriodicBinaryBodyData(xmlSct, jsonStandingOrderType);
        }
        return this.buildBinaryBodyData(this.httpServletRequest);
    }

    private <R> R validatePayment(Object payment, Class<R> clazz) {
        ObjectMapper customMapper = this.xs2aObjectMapper.copy();
        customMapper.registerModule((Module)this.getDayOfExecutionDeserializerModule());
        Object result = customMapper.convertValue(payment, clazz);
        this.validationService.validate(result, new Class[0]);
        return (R)result;
    }

    private byte[] buildBinaryBodyData(HttpServletRequest httpServletRequest) {
        try {
            return IOUtils.toByteArray((InputStream)httpServletRequest.getInputStream());
        }
        catch (IOException e) {
            log.warn("Cannot deserialize httpServletRequest body!", (Throwable)e);
            return null;
        }
    }

    private byte[] buildPeriodicBinaryBodyData(Object xmlPart, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonPart) {
        String serialisedJsonPart = null;
        try {
            serialisedJsonPart = this.xs2aObjectMapper.writeValueAsString((Object)jsonPart);
        }
        catch (JsonProcessingException e) {
            log.info("Can't convert object to json: {}", (Object)e.getMessage());
        }
        if (xmlPart == null || serialisedJsonPart == null) {
            throw new IllegalArgumentException("Invalid body of the multipart request!");
        }
        String body = xmlPart + "\n" + serialisedJsonPart;
        return body.getBytes(Charset.forName("UTF-8"));
    }

    private SimpleModule getDayOfExecutionDeserializerModule() {
        SimpleModule dayOfExecutionModule = new SimpleModule();
        dayOfExecutionModule.addDeserializer(DayOfExecution.class, (JsonDeserializer)new DayOfExecutionDeserializer());
        return dayOfExecutionModule;
    }

    @ConstructorProperties(value={"validationService", "httpServletRequest", "xs2aObjectMapper", "paymentModelMapper", "standardPaymentProductsResolver"})
    public PaymentModelMapperXs2a(ValueValidatorService validationService, HttpServletRequest httpServletRequest, Xs2aObjectMapper xs2aObjectMapper, PaymentModelMapper paymentModelMapper, StandardPaymentProductsResolver standardPaymentProductsResolver) {
        this.validationService = validationService;
        this.httpServletRequest = httpServletRequest;
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.paymentModelMapper = paymentModelMapper;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
    }
}

