/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.CancellationList;
import de.adorsys.psd2.model.Cancellations;
import de.adorsys.psd2.model.ConsentInformationResponse200Json;
import de.adorsys.psd2.model.ConsentStatus;
import de.adorsys.psd2.model.ConsentStatusResponse200;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.model.ConsentsResponse201;
import de.adorsys.psd2.model.MessageCode2XX;
import de.adorsys.psd2.model.TppMessage2XX;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Component;

@Component
public class ConsentModelMapper {
    private final Xs2aObjectMapper xs2aObjectMapper;
    public final AccountModelMapper accountModelMapper;
    private final HrefLinkMapper hrefLinkMapper;
    private final ScaMethodsMapper scaMethodsMapper;

    public CreateConsentReq mapToCreateConsentReq(Consents consent, TppRedirectUri tppRedirectUri) {
        return Optional.ofNullable(consent).map(cnst -> {
            CreateConsentReq createAisConsentRequest = new CreateConsentReq();
            createAisConsentRequest.setAccess(this.mapToAccountAccessInner(cnst.getAccess()));
            createAisConsentRequest.setRecurringIndicator(cnst.getRecurringIndicator());
            createAisConsentRequest.setValidUntil(cnst.getValidUntil());
            createAisConsentRequest.setFrequencyPerDay(cnst.getFrequencyPerDay());
            createAisConsentRequest.setCombinedServiceIndicator(BooleanUtils.toBoolean((Boolean)cnst.isCombinedServiceIndicator()));
            createAisConsentRequest.setTppRedirectUri(tppRedirectUri);
            return createAisConsentRequest;
        }).orElse(null);
    }

    public ConsentStatusResponse200 mapToConsentStatusResponse200(ConsentStatusResponse consentStatusResponse) {
        return Optional.ofNullable(consentStatusResponse).map(cstr -> new ConsentStatusResponse200().consentStatus(ConsentStatus.fromValue((String)cstr.getConsentStatus()))).orElse(null);
    }

    public ConsentsResponse201 mapToConsentsResponse201(CreateConsentResponse createConsentResponse) {
        return Optional.ofNullable(createConsentResponse).map(cnst -> new ConsentsResponse201().consentStatus(ConsentStatus.fromValue((String)cnst.getConsentStatus())).consentId(cnst.getConsentId()).scaMethods(this.scaMethodsMapper.mapToScaMethods(cnst.getScaMethods()))._links(this.hrefLinkMapper.mapToLinksMap(cnst.getLinks())).psuMessage(cnst.getPsuMessage()).tppMessages(this.mapToTppMessage2XXList(cnst.getTppMessageInformation()))).orElse(null);
    }

    public ConsentInformationResponse200Json mapToConsentInformationResponse200Json(AccountConsent accountConsent) {
        return Optional.ofNullable(accountConsent).map(consent -> new ConsentInformationResponse200Json().access(this.mapToAccountAccessDomain(consent.getAccess())).recurringIndicator(Boolean.valueOf(consent.isRecurringIndicator())).validUntil(consent.getValidUntil()).frequencyPerDay(Integer.valueOf(consent.getFrequencyPerDay())).lastActionDate(consent.getLastActionDate()).consentStatus(ConsentStatus.fromValue((String)consent.getConsentStatus().getValue()))).orElse(null);
    }

    private Xs2aAccountAccess mapToAccountAccessInner(AccountAccess accountAccess) {
        return Optional.ofNullable(accountAccess).map(acs -> new Xs2aAccountAccess(this.mapToXs2aAccountReferences(acs.getAccounts()), this.mapToXs2aAccountReferences(acs.getBalances()), this.mapToXs2aAccountReferences(acs.getTransactions()), this.mapToAccountAccessTypeFromAvailableAccounts(acs.getAvailableAccounts()), this.mapToAccountAccessTypeFromAllPsd2Enum(acs.getAllPsd2()), this.mapToAccountAccessTypeFromAvailableAccountsWithBalance(acs.getAvailableAccountsWithBalance()))).orElse(null);
    }

    private AccountAccess mapToAccountAccessDomain(Xs2aAccountAccess accountAccess) {
        return Optional.ofNullable(accountAccess).map(access -> {
            AccountAccess mappedAccountAccess = new AccountAccess();
            mappedAccountAccess.setAccounts(this.accountModelMapper.mapToAccountReferences(access.getAccounts()));
            mappedAccountAccess.setBalances(this.accountModelMapper.mapToAccountReferences(access.getBalances()));
            mappedAccountAccess.setTransactions(this.accountModelMapper.mapToAccountReferences(access.getTransactions()));
            mappedAccountAccess.setAvailableAccounts(AccountAccess.AvailableAccountsEnum.fromValue((String)Optional.ofNullable(access.getAvailableAccounts()).map(AccountAccessType::getDescription).orElse(null)));
            mappedAccountAccess.setAllPsd2(AccountAccess.AllPsd2Enum.fromValue((String)Optional.ofNullable(access.getAllPsd2()).map(AccountAccessType::getDescription).orElse(null)));
            mappedAccountAccess.setAvailableAccountsWithBalance(AccountAccess.AvailableAccountsWithBalanceEnum.fromValue((String)Optional.ofNullable(access.getAvailableAccountsWithBalance()).map(AccountAccessType::getDescription).orElse(null)));
            return mappedAccountAccess;
        }).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAvailableAccounts(AccountAccess.AvailableAccountsEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAllPsd2Enum(AccountAccess.AllPsd2Enum allPsd2Enum) {
        return Optional.ofNullable(allPsd2Enum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAvailableAccountsWithBalance(AccountAccess.AvailableAccountsWithBalanceEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private List<de.adorsys.psd2.xs2a.core.profile.AccountReference> mapToXs2aAccountReferences(List<AccountReference> references) {
        return Optional.ofNullable(references).map(ref -> ref.stream().map(this::mapToAccountReference).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(Object reference) {
        return (de.adorsys.psd2.xs2a.core.profile.AccountReference)this.xs2aObjectMapper.convertValue(reference, de.adorsys.psd2.xs2a.core.profile.AccountReference.class);
    }

    public UpdateConsentPsuDataReq mapToUpdatePsuData(PsuIdData psuData, String consentId, String authorizationId, Map body) {
        UpdateConsentPsuDataReq updatePsuData = new UpdateConsentPsuDataReq();
        updatePsuData.setPsuData(psuData);
        updatePsuData.setConsentId(consentId);
        updatePsuData.setAuthorizationId(authorizationId);
        if (body != null && !body.isEmpty()) {
            Optional.ofNullable(body.get("psuData")).map(o -> (LinkedHashMap)o).ifPresent(psuDataMap -> updatePsuData.setPassword((String)psuDataMap.get("password")));
            Optional.ofNullable(body.get("authenticationMethodId")).map(o -> (String)o).ifPresent(updatePsuData::setAuthenticationMethodId);
            Optional.ofNullable(body.get("scaAuthenticationData")).map(o -> (String)o).ifPresent(updatePsuData::setScaAuthenticationData);
        } else {
            updatePsuData.setUpdatePsuIdentification(true);
        }
        return updatePsuData;
    }

    public Cancellations mapToCancellations(Xs2aPaymentCancellationAuthorisationSubResource idsContainer) {
        return Optional.ofNullable(idsContainer.getCancellationIds()).map(this::buildCancellations).orElseGet(Cancellations::new);
    }

    public Xs2aUpdatePisCommonPaymentPsuDataRequest mapToPisUpdatePsuData(PsuIdData psuData, String paymentId, String authorisationId, PaymentType paymentService, String paymentProduct, Map body) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = new Xs2aUpdatePisCommonPaymentPsuDataRequest();
        request.setPsuData(psuData);
        request.setPaymentId(paymentId);
        request.setAuthorisationId(authorisationId);
        request.setPaymentService(paymentService);
        request.setPaymentProduct(paymentProduct);
        if (body != null && !body.isEmpty()) {
            Optional.ofNullable(body.get("psuData")).map(o -> (LinkedHashMap)o).ifPresent(psuDataMap -> request.setPassword((String)psuDataMap.get("password")));
            Optional.ofNullable(body.get("authenticationMethodId")).map(o -> (String)o).ifPresent(request::setAuthenticationMethodId);
            Optional.ofNullable(body.get("scaAuthenticationData")).ifPresent(authData -> request.setScaAuthenticationData((String)authData));
        } else {
            request.setUpdatePsuIdentification(true);
        }
        return request;
    }

    private Cancellations buildCancellations(List<String> cancellationIds) {
        Cancellations cancellations = new Cancellations();
        CancellationList cancellationList = new CancellationList();
        cancellationList.addAll(cancellationIds);
        cancellations.setCancellationIds(cancellationList);
        return cancellations;
    }

    private List<TppMessage2XX> mapToTppMessage2XXList(Set<TppMessageInformation> tppMessages) {
        if (CollectionUtils.isEmpty(tppMessages)) {
            return null;
        }
        return tppMessages.stream().map(this::mapToTppMessage2XX).collect(Collectors.toList());
    }

    private TppMessage2XX mapToTppMessage2XX(TppMessageInformation tppMessage) {
        TppMessage2XX tppMessage2XX = new TppMessage2XX();
        tppMessage2XX.setCategory(TppMessageCategory.fromValue((String)tppMessage.getCategory().name()));
        tppMessage2XX.setCode(MessageCode2XX.WARNING);
        tppMessage2XX.setPath(tppMessage.getPath());
        tppMessage2XX.setText(tppMessage.getText());
        return tppMessage2XX;
    }

    @ConstructorProperties(value={"xs2aObjectMapper", "accountModelMapper", "hrefLinkMapper", "scaMethodsMapper"})
    public ConsentModelMapper(Xs2aObjectMapper xs2aObjectMapper, AccountModelMapper accountModelMapper, HrefLinkMapper hrefLinkMapper, ScaMethodsMapper scaMethodsMapper) {
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.accountModelMapper = accountModelMapper;
        this.hrefLinkMapper = hrefLinkMapper;
        this.scaMethodsMapper = scaMethodsMapper;
    }
}

