/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web;

import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class RedirectLinkBuilder {
    private static final String REDIRECT_URL = "{redirect-id}";
    private static final String ENCRYPTED_CONSENT_ID = "{encrypted-consent-id}";
    private static final String ENCRYPTED_PAYMENT_ID = "{encrypted-payment-id}";
    private static final String INTERNAL_REQUEST_ID = "{inr-id}";
    private final AspspProfileServiceWrapper aspspProfileService;

    public String buildConsentScaRedirectLink(String encryptedConsentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getAisRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_CONSENT_ID, encryptedConsentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    public String buildPaymentScaRedirectLink(String encryptedPaymentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getPisRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_PAYMENT_ID, encryptedPaymentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    public String buildPaymentCancellationScaRedirectLink(String encryptedPaymentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getPisPaymentCancellationRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_PAYMENT_ID, encryptedPaymentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public RedirectLinkBuilder(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

