/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.tpp;

import com.google.common.net.InternetDomainName;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TppDomainValidator
implements BusinessValidator<String> {
    private static final Logger log = LoggerFactory.getLogger(TppDomainValidator.class);
    private static final String INVALID_DOMAIN_MESSAGE = "TPP URIs are not compliant with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate";
    private static final String PATTERN_FOR_NORMALIZE_DOMAIN = "\\*.";
    private final TppMessageInformation INVALID_DOMAIN_WARNING_MESSAGE = TppMessageInformation.buildWarning("TPP URIs are not compliant with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate");
    private final TppService tppService;
    private final RequestProviderService requestProviderService;
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    @Override
    public ValidationResult validate(String header) {
        return ValidationResult.valid();
    }

    @Override
    public Set<TppMessageInformation> buildWarningMessages(@NotNull String urlString) {
        HashSet<TppMessageInformation> warningMessages = new HashSet<TppMessageInformation>();
        if (!this.aspspProfileServiceWrapper.isCheckUriComplianceToDomainSupported()) {
            return warningMessages;
        }
        if (StringUtils.isNotBlank((CharSequence)urlString)) {
            List<URL> certificateUrls = this.getDomainsFromTppInfo().stream().map(this::buildURL).filter(Objects::nonNull).collect(Collectors.toList());
            if (certificateUrls.isEmpty()) {
                return warningMessages;
            }
            URL url = this.buildURL(urlString);
            if (url == null) {
                warningMessages.add(this.INVALID_DOMAIN_WARNING_MESSAGE);
                return warningMessages;
            }
            if (!this.isUrlCompliant(url, certificateUrls)) {
                warningMessages.add(this.INVALID_DOMAIN_WARNING_MESSAGE);
            }
        }
        return warningMessages;
    }

    private boolean isUrlCompliant(URL urlHeader, List<URL> certificateUrls) {
        String topDomainUrl = this.getTopDomain(urlHeader.getHost());
        return certificateUrls.stream().map(URL::getHost).map(this::getTopDomain).filter(Objects::nonNull).anyMatch(topDomainCertificate -> Objects.equals(topDomainCertificate, topDomainUrl));
    }

    private URL buildURL(String domain) {
        try {
            String normalizedDomain = this.normalizeDomain(domain);
            URL url = new URL(this.getDomainWithProtocol(normalizedDomain));
            if (InternetDomainName.from((String)url.getHost()).hasPublicSuffix()) {
                return url;
            }
        }
        catch (MalformedURLException e) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}] Cannot build URL from [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), domain});
        }
        return null;
    }

    private String normalizeDomain(String domain) {
        return domain.replaceAll(PATTERN_FOR_NORMALIZE_DOMAIN, "");
    }

    private List<String> getDomainsFromTppInfo() {
        TppInfo tppInfo = this.tppService.getTppInfo();
        ArrayList dnsList = new ArrayList();
        Optional.ofNullable(tppInfo.getTppName()).filter(InternetDomainName::isValid).ifPresent(dnsList::add);
        dnsList.addAll(tppInfo.getDnsList());
        return dnsList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private String getDomainWithProtocol(String domain) {
        return domain.startsWith("http") ? domain : "http://" + domain;
    }

    private String getTopDomain(String host) {
        try {
            return InternetDomainName.from((String)host).topPrivateDomain().toString();
        }
        catch (IllegalStateException ex) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}] Cannot get top domain from [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), host});
            return null;
        }
    }

    @ConstructorProperties(value={"tppService", "requestProviderService", "aspspProfileServiceWrapper"})
    public TppDomainValidator(TppService tppService, RequestProviderService requestProviderService, AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.tppService = tppService;
        this.requestProviderService = requestProviderService;
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

