/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.read;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.service.payment.read.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadPaymentService
implements ReadPaymentService {
    private static final Logger log = LoggerFactory.getLogger(AbstractReadPaymentService.class);
    protected SpiContextDataProvider spiContextDataProvider;
    protected SpiPaymentFactory spiPaymentFactory;
    private SpiErrorMapper spiErrorMapper;
    private SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private RequestProviderService requestProviderService;
    private Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService;

    public AbstractReadPaymentService(SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, RequestProviderService requestProviderService, Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService, SpiContextDataProvider spiContextDataProvider, SpiPaymentFactory spiPaymentFactory) {
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiPaymentFactory = spiPaymentFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.requestProviderService = requestProviderService;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
    }

    @Override
    public PaymentInformationResponse<CommonPayment> getPayment(CommonPaymentData commonPaymentData, PsuIdData psuData, @NotNull String encryptedPaymentId) {
        List<PisPayment> pisPayments = this.getPisPayments(commonPaymentData);
        if (CollectionUtils.isEmpty(pisPayments)) {
            return new PaymentInformationResponse<CommonPayment>(ErrorHolder.builder(ErrorType.PIS_400).tppMessages(TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_PAYMENT_NOT_FOUND)).build());
        }
        Optional spiPaymentOptional = this.createSpiPayment(pisPayments, commonPaymentData.getPaymentProduct());
        if (!spiPaymentOptional.isPresent()) {
            return new PaymentInformationResponse<CommonPayment>(ErrorHolder.builder(ErrorType.PIS_404).tppMessages(TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build());
        }
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId);
        SpiResponse spiResponse = this.getSpiPaymentById(spiContextData, spiPaymentOptional.get(), aspspConsentDataProvider);
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Read payment failed. Can't get payment by ID at SPI level. Error msg: [{}]", new Object[]{internalRequestId, xRequestId, ((SpiPayment)spiPaymentOptional.get()).getPaymentId(), errorHolder});
            return new PaymentInformationResponse<CommonPayment>(errorHolder);
        }
        CommonPayment xs2aPayment = this.getXs2aPayment(spiResponse);
        TransactionStatus paymentStatus = xs2aPayment.getTransactionStatus();
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, paymentStatus)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Internal payment ID: [{}], Transaction status: [{}]. Update of a payment status in the CMS has failed.", new Object[]{internalRequestId, xRequestId, xs2aPayment.getPaymentId(), paymentStatus});
        }
        return new PaymentInformationResponse<CommonPayment>(xs2aPayment);
    }

    protected abstract Optional createSpiPayment(List<PisPayment> var1, String var2);

    protected abstract SpiResponse getSpiPaymentById(SpiContextData var1, Object var2, SpiAspspConsentDataProvider var3);

    protected abstract CommonPayment getXs2aPayment(SpiResponse var1);

    private List<PisPayment> getPisPayments(CommonPaymentData commonPaymentData) {
        List pisPayments = Optional.of(commonPaymentData).map(CommonPaymentData::getPayments).orElseGet(Collections::emptyList);
        pisPayments.forEach(pmt -> {
            pmt.setPaymentId(commonPaymentData.getExternalId());
            pmt.setTransactionStatus(commonPaymentData.getTransactionStatus());
            pmt.setPsuDataList(commonPaymentData.getPsuData());
            pmt.setStatusChangeTimestamp(commonPaymentData.getStatusChangeTimestamp());
            pmt.setContentType(commonPaymentData.getContentType());
        });
        return pisPayments;
    }
}

