/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.discovery;

import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

class ServiceTypeDiscovery {
    private static final Logger log = LoggerFactory.getLogger(ServiceTypeDiscovery.class);
    private static final AntPathMatcher matcher = new AntPathMatcher();
    private static final Map<String, ServiceType> pathToServiceType = new HashMap<String, ServiceType>();

    ServiceTypeDiscovery() {
    }

    static ServiceType getServiceType(String targetPath, UUID internalRequestId, String xRequestId) {
        for (Map.Entry<String, ServiceType> entry : pathToServiceType.entrySet()) {
            String pattern = entry.getKey();
            if (!matcher.match(pattern, targetPath)) continue;
            return entry.getValue();
        }
        log.warn("InR-ID: [{}], X-Request-ID: [{}]. Can't get ServiceType because illegal path: [{}]", new Object[]{internalRequestId, xRequestId, targetPath});
        throw new IllegalArgumentException("Illegal path: " + targetPath);
    }

    static {
        pathToServiceType.put("/v1/accounts/**", ServiceType.AIS);
        pathToServiceType.put("/v1/consents/**", ServiceType.AIS);
        pathToServiceType.put("/v1/payments/**", ServiceType.PIS);
        pathToServiceType.put("/v1/periodic-payments/**", ServiceType.PIS);
        pathToServiceType.put("/v1/bulk-payments/**", ServiceType.PIS);
        pathToServiceType.put("/v1/funds-confirmations/**", ServiceType.PIIS);
        pathToServiceType.put("/v1/signing-baskets/**", ServiceType.SB);
    }
}

