/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.exception;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class MessageError {
    @JsonUnwrapped
    private Set<TppMessageInformation> tppMessages = new HashSet<TppMessageInformation>();
    private ErrorType errorType;

    public MessageError(ErrorType errorType, TppMessageInformation ... tppMessageInformation) {
        this.errorType = errorType;
        this.fillTppMessage(tppMessageInformation);
    }

    public void addTppMessage(TppMessageInformation tppMessageInformation) {
        this.tppMessages.add(tppMessageInformation);
    }

    public MessageError(ErrorHolder errorHolder) {
        this.tppMessages.addAll(errorHolder.getTppMessageInformationList());
        this.errorType = errorHolder.getErrorType();
    }

    @JsonIgnore
    public TppMessageInformation getTppMessage() {
        return this.tppMessages.iterator().next();
    }

    private void fillTppMessage(TppMessageInformation ... tppMessages) {
        if (this.isNotEmpty(tppMessages)) {
            this.tppMessages.addAll(Arrays.stream(tppMessages).collect(Collectors.toSet()));
        }
    }

    private boolean isNotEmpty(TppMessageInformation ... tppMessages) {
        return tppMessages != null && tppMessages.length >= 1;
    }

    public String toString() {
        return CollectionUtils.isEmpty(this.tppMessages) ? Optional.ofNullable(this.errorType).map(Enum::name).orElse("") : this.tppMessages.stream().map(info -> info.getMessageErrorCode().getName()).collect(Collectors.joining(", "));
    }

    public Set<TppMessageInformation> getTppMessages() {
        return this.tppMessages;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setTppMessages(Set<TppMessageInformation> tppMessages) {
        this.tppMessages = tppMessages;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageError)) {
            return false;
        }
        MessageError other = (MessageError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<TppMessageInformation> this$tppMessages = this.getTppMessages();
        Set<TppMessageInformation> other$tppMessages = other.getTppMessages();
        if (this$tppMessages == null ? other$tppMessages != null : !((Object)this$tppMessages).equals(other$tppMessages)) {
            return false;
        }
        ErrorType this$errorType = this.getErrorType();
        ErrorType other$errorType = other.getErrorType();
        return !(this$errorType == null ? other$errorType != null : !((Object)((Object)this$errorType)).equals((Object)other$errorType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<TppMessageInformation> $tppMessages = this.getTppMessages();
        result = result * 59 + ($tppMessages == null ? 43 : ((Object)$tppMessages).hashCode());
        ErrorType $errorType = this.getErrorType();
        result = result * 59 + ($errorType == null ? 43 : ((Object)((Object)$errorType)).hashCode());
        return result;
    }

    public MessageError() {
    }
}

