/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import java.util.Arrays;

public class TppMessageInformation {
    private MessageCategory category;
    private MessageErrorCode messageErrorCode;
    private String path;
    private Object[] textParameters;
    private String text;

    public static TppMessageInformation buildWithCustomError(MessageErrorCode messageErrorCode, String text) {
        return new TppMessageInformation(MessageCategory.ERROR, messageErrorCode, null, text, null);
    }

    public static TppMessageInformation buildWarning(String text) {
        return new TppMessageInformation(MessageCategory.WARNING, null, null, text, new Object[0]);
    }

    public static TppMessageInformation of(MessageErrorCode messageErrorCode) {
        return TppMessageInformation.of(MessageCategory.ERROR, messageErrorCode, null);
    }

    public static TppMessageInformation of(MessageErrorCode messageErrorCode, Object ... textParameters) {
        return TppMessageInformation.of(MessageCategory.ERROR, messageErrorCode, textParameters);
    }

    public static TppMessageInformation of(MessageCategory category, MessageErrorCode messageErrorCode) {
        return TppMessageInformation.of(category, messageErrorCode, null, null);
    }

    public static TppMessageInformation of(MessageCategory category, MessageErrorCode messageErrorCode, Object ... textParameters) {
        return TppMessageInformation.of(category, messageErrorCode, null, textParameters);
    }

    public static TppMessageInformation of(MessageCategory category, MessageErrorCode messageErrorCode, String path, Object ... textParameters) {
        return new TppMessageInformation(category, messageErrorCode, path, null, textParameters);
    }

    private TppMessageInformation(MessageCategory category, MessageErrorCode messageErrorCode, String path, String text, Object ... textParameters) {
        this.category = category;
        this.messageErrorCode = messageErrorCode;
        this.path = path;
        this.text = text;
        this.textParameters = textParameters;
    }

    public MessageCategory getCategory() {
        return this.category;
    }

    public MessageErrorCode getMessageErrorCode() {
        return this.messageErrorCode;
    }

    public String getPath() {
        return this.path;
    }

    public Object[] getTextParameters() {
        return this.textParameters;
    }

    public String getText() {
        return this.text;
    }

    public void setCategory(MessageCategory category) {
        this.category = category;
    }

    public void setMessageErrorCode(MessageErrorCode messageErrorCode) {
        this.messageErrorCode = messageErrorCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTextParameters(Object[] textParameters) {
        this.textParameters = textParameters;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "TppMessageInformation(category=" + (Object)((Object)this.getCategory()) + ", messageErrorCode=" + this.getMessageErrorCode() + ", path=" + this.getPath() + ", textParameters=" + Arrays.deepToString(this.getTextParameters()) + ", text=" + this.getText() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TppMessageInformation)) {
            return false;
        }
        TppMessageInformation other = (TppMessageInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MessageCategory this$category = this.getCategory();
        MessageCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        MessageErrorCode this$messageErrorCode = this.getMessageErrorCode();
        MessageErrorCode other$messageErrorCode = other.getMessageErrorCode();
        if (this$messageErrorCode == null ? other$messageErrorCode != null : !this$messageErrorCode.equals(other$messageErrorCode)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTextParameters(), other.getTextParameters())) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TppMessageInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        MessageErrorCode $messageErrorCode = this.getMessageErrorCode();
        result = result * 59 + ($messageErrorCode == null ? 43 : $messageErrorCode.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTextParameters());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }
}

