/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.piis;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.AccountReferenceValidator;
import de.adorsys.psd2.xs2a.web.validator.body.AmountValidator;
import de.adorsys.psd2.xs2a.web.validator.body.CurrencyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.piis.FundsConfirmationBodyValidator;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class FundsConfirmationBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements FundsConfirmationBodyValidator {
    private final AccountReferenceValidator accountReferenceValidator;
    private final AmountValidator amountValidator;
    private final CurrencyValidator currencyValidator;

    public FundsConfirmationBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, AccountReferenceValidator accountReferenceValidator, AmountValidator amountValidator, CurrencyValidator currencyValidator) {
        super(errorBuildingService, objectMapper);
        this.accountReferenceValidator = accountReferenceValidator;
        this.amountValidator = amountValidator;
        this.currencyValidator = currencyValidator;
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        Optional<ConfirmationOfFunds> confirmationOfFundsOptional = this.mapBodyToInstance(request, messageError, ConfirmationOfFunds.class);
        if (!confirmationOfFundsOptional.isPresent()) {
            return;
        }
        ConfirmationOfFunds confirmationOfFunds = confirmationOfFundsOptional.get();
        if (confirmationOfFunds.getAccount() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_NULL_VALUE, "access"));
        } else {
            this.accountReferenceValidator.validate(confirmationOfFunds.getAccount(), messageError);
        }
        if (confirmationOfFunds.getInstructedAmount() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_NULL_VALUE, "instructedAmount"));
        } else {
            this.validateAmount(confirmationOfFunds.getInstructedAmount(), messageError);
        }
    }

    private void validateAmount(Amount instructedAmount, MessageError messageError) {
        this.currencyValidator.validateCurrency(instructedAmount.getCurrency(), messageError);
        this.amountValidator.validateAmount(instructedAmount.getAmount(), messageError);
    }
}

