/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class ErrorBuildingService {
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;
    private final ErrorMapperContainer errorMapperContainer;
    private final ObjectMapper objectMapper;

    public void buildErrorResponse(HttpServletResponse response, MessageError messageError) throws IOException {
        response.resetBuffer();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        Set<TppMessageInformation> tppMessages = messageError.getTppMessages();
        response.setStatus(tppMessages.iterator().next().getMessageErrorCode().getCode());
        response.getWriter().write(this.objectMapper.writeValueAsString(this.createError(tppMessages)));
        response.flushBuffer();
    }

    public void enrichMessageError(MessageError messageError, MessageError validationMessageError) {
        this.enrichMessageError(messageError, validationMessageError.getTppMessage());
    }

    public void enrichMessageError(MessageError messageError, TppMessageInformation tppMessageInformation) {
        messageError.addTppMessage(tppMessageInformation);
    }

    public ErrorType buildErrorType() {
        return this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.FORMAT_ERROR.getCode());
    }

    private Object createError(Set<TppMessageInformation> tppMessageInformations) {
        MessageError messageError = this.getMessageError(tppMessageInformations);
        return Optional.ofNullable(this.errorMapperContainer.getErrorBody(messageError)).map(ErrorMapperContainer.ErrorBody::getBody).orElse(null);
    }

    private MessageError getMessageError(Set<TppMessageInformation> tppMessages) {
        ErrorType errorType = this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.FORMAT_ERROR.getCode());
        return new MessageError(errorType, tppMessages.toArray(new TppMessageInformation[tppMessages.size()]));
    }

    @ConstructorProperties(value={"serviceTypeDiscoveryService", "errorTypeMapper", "errorMapperContainer", "objectMapper"})
    public ErrorBuildingService(ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper, ErrorMapperContainer errorMapperContainer, ObjectMapper objectMapper) {
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
        this.errorMapperContainer = errorMapperContainer;
        this.objectMapper = objectMapper;
    }
}

