/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.MethodValidator;
import de.adorsys.psd2.xs2a.web.validator.body.BodyValidator;
import de.adorsys.psd2.xs2a.web.validator.header.HeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.path.PathParameterValidator;
import de.adorsys.psd2.xs2a.web.validator.query.QueryParameterValidator;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.HandlerMapping;

public abstract class AbstractMethodValidator<H extends HeaderValidator, B extends BodyValidator, Q extends QueryParameterValidator, P extends PathParameterValidator>
implements MethodValidator {
    private final List<H> headerValidators;
    private final List<B> bodyValidators;
    private final List<Q> queryParameterValidators;
    private final List<P> pathParameterValidators;

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(h -> h, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
        TreeMap<String, String> caseInsensitiveHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveHeaders.putAll(headers);
        Map<String, List<String>> queryParameters = this.extractQueryParameters(request);
        Map<String, String> pathParameters = this.extractPathParameters(request);
        this.getPathParameterValidators().forEach(v -> v.validate(pathParameters, messageError));
        this.getQueryParameterValidators().forEach(v -> v.validate(queryParameters, messageError));
        this.getHeaderValidators().forEach(v -> v.validate(caseInsensitiveHeaders, messageError));
        this.getBodyValidators().forEach(v -> v.validate(request, messageError));
    }

    private Map<String, String> extractPathParameters(HttpServletRequest request) {
        return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
    }

    private Map<String, List<String>> extractQueryParameters(HttpServletRequest request) {
        Map requestParameterMap = request.getParameterMap();
        return requestParameterMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.asList((Object[])e.getValue())));
    }

    @ConstructorProperties(value={"headerValidators", "bodyValidators", "queryParameterValidators", "pathParameterValidators"})
    protected AbstractMethodValidator(List<H> headerValidators, List<B> bodyValidators, List<Q> queryParameterValidators, List<P> pathParameterValidators) {
        this.headerValidators = headerValidators;
        this.bodyValidators = bodyValidators;
        this.queryParameterValidators = queryParameterValidators;
        this.pathParameterValidators = pathParameterValidators;
    }

    List<H> getHeaderValidators() {
        return this.headerValidators;
    }

    List<B> getBodyValidators() {
        return this.bodyValidators;
    }

    List<Q> getQueryParameterValidators() {
        return this.queryParameterValidators;
    }

    List<P> getPathParameterValidators() {
        return this.pathParameterValidators;
    }
}

