/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationScaStatusPO;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetPaymentInitiationAuthorisationScaStatusValidator
extends AbstractPisTppValidator<GetPaymentInitiationAuthorisationScaStatusPO> {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentInitiationAuthorisationScaStatusValidator.class);
    private final PisAuthorisationValidator pisAuthorisationValidator;

    @Override
    protected ValidationResult executeBusinessValidation(GetPaymentInitiationAuthorisationScaStatusPO paymentObject) {
        PisCommonPaymentResponse response = paymentObject.getPisCommonPaymentResponse();
        String authorisationId = paymentObject.getAuthorisationId();
        ValidationResult authorisationValidationResult = this.pisAuthorisationValidator.validate(authorisationId, response);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"pisAuthorisationValidator"})
    public GetPaymentInitiationAuthorisationScaStatusValidator(PisAuthorisationValidator pisAuthorisationValidator) {
        this.pisAuthorisationValidator = pisAuthorisationValidator;
    }
}

