/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis;

import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.PaymentTypeAndInfoProvider;
import de.adorsys.psd2.xs2a.service.validator.pis.PaymentTypeAndProductValidator;
import de.adorsys.psd2.xs2a.service.validator.tpp.PisTppInfoValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractPisTppValidator<T extends PaymentTypeAndInfoProvider>
implements BusinessValidator<T> {
    private PisTppInfoValidator pisTppInfoValidator;
    private PaymentTypeAndProductValidator paymentProductAndTypeValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull T object) {
        ValidationResult productAndTypeValidationResult = this.paymentProductAndTypeValidator.validateTypeAndProduct(object.getPaymentType(), object.getPaymentProduct());
        if (productAndTypeValidationResult.isNotValid()) {
            return productAndTypeValidationResult;
        }
        TppInfo tppInfoInPayment = object.getTppInfo();
        ValidationResult tppValidationResult = this.pisTppInfoValidator.validateTpp(tppInfoInPayment);
        if (tppValidationResult.isNotValid()) {
            return tppValidationResult;
        }
        return this.executeBusinessValidation(object);
    }

    protected abstract ValidationResult executeBusinessValidation(T var1);

    @Autowired
    public void setPisValidators(PisTppInfoValidator pisTppInfoValidator, PaymentTypeAndProductValidator paymentProductAndTypeValidator) {
        this.pisTppInfoValidator = pisTppInfoValidator;
        this.paymentProductAndTypeValidator = paymentProductAndTypeValidator;
    }
}

