/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.AisPsuDataUpdateAuthorisationCheckerValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AbstractConsentTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AisAuthorisationStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.UpdateConsentPsuDataRequestObject;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class UpdateConsentPsuDataValidator
extends AbstractConsentTppValidator<UpdateConsentPsuDataRequestObject> {
    private final AisAuthorisationValidator aisAuthorisationValidator;
    private final AisAuthorisationStatusValidator aisAuthorisationStatusValidator;
    private final AisPsuDataUpdateAuthorisationCheckerValidator aisPsuDataUpdateAuthorisationCheckerValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(UpdateConsentPsuDataRequestObject requestObject) {
        AccountConsent consent = requestObject.getAccountConsent();
        String authorisationId = requestObject.getAuthorisationId();
        ValidationResult authorisationValidationResult = this.aisAuthorisationValidator.validate(authorisationId, consent);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        Optional<AccountConsentAuthorization> authorisationOptional = consent.findAuthorisationInConsent(authorisationId);
        if (!authorisationOptional.isPresent()) {
            return ValidationResult.invalid(ErrorType.AIS_403, MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        AccountConsentAuthorization authorisation = authorisationOptional.get();
        ValidationResult validationResult = this.aisPsuDataUpdateAuthorisationCheckerValidator.validate(requestObject.getPsuIdData(), authorisation.getPsuIdData());
        if (validationResult.isNotValid()) {
            return validationResult;
        }
        ValidationResult authorisationStatusValidationResult = this.aisAuthorisationStatusValidator.validate(authorisation.getScaStatus());
        if (authorisationStatusValidationResult.isNotValid()) {
            return authorisationStatusValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"aisAuthorisationValidator", "aisAuthorisationStatusValidator", "aisPsuDataUpdateAuthorisationCheckerValidator"})
    public UpdateConsentPsuDataValidator(AisAuthorisationValidator aisAuthorisationValidator, AisAuthorisationStatusValidator aisAuthorisationStatusValidator, AisPsuDataUpdateAuthorisationCheckerValidator aisPsuDataUpdateAuthorisationCheckerValidator) {
        this.aisAuthorisationValidator = aisAuthorisationValidator;
        this.aisAuthorisationStatusValidator = aisAuthorisationStatusValidator;
        this.aisPsuDataUpdateAuthorisationCheckerValidator = aisPsuDataUpdateAuthorisationCheckerValidator;
    }
}

