/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AbstractConsentTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationScaStatusPO;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetConsentAuthorisationScaStatusValidator
extends AbstractConsentTppValidator<GetConsentAuthorisationScaStatusPO> {
    private final AisAuthorisationValidator aisAuthorisationValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetConsentAuthorisationScaStatusPO consentObject) {
        AccountConsent response = consentObject.getAccountConsent();
        String authorisationId = consentObject.getAuthorisationId();
        ValidationResult authorisationValidationResult = this.aisAuthorisationValidator.validate(authorisationId, response);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"aisAuthorisationValidator"})
    public GetConsentAuthorisationScaStatusValidator(AisAuthorisationValidator aisAuthorisationValidator) {
        this.aisAuthorisationValidator = aisAuthorisationValidator;
    }
}

