/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetCommonPaymentByIdResponseValidator {
    private static final Logger log = LoggerFactory.getLogger(GetCommonPaymentByIdResponseValidator.class);
    private final RequestProviderService requestProviderService;

    public ValidationResult validateRequest(@Nullable PisCommonPaymentResponse pisCommonPayment, PaymentType paymentType, String paymentProduct) {
        if (pisCommonPayment == null) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Payment validation has failed: payment was not found", (Object)this.requestProviderService.getInternalRequestId(), (Object)this.requestProviderService.getRequestId());
            return ValidationResult.invalid(ErrorType.PIS_404, MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT);
        }
        if (this.isPaymentTypeIncorrect(paymentType, pisCommonPayment)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Payment validation has failed: payment type [{}] is incorrect", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), pisCommonPayment.getExternalId(), paymentType});
            return ValidationResult.invalid(ErrorType.PIS_405, MessageErrorCode.SERVICE_INVALID_400_FOR_PAYMENT);
        }
        if (this.isPaymentProductIncorrect(paymentProduct, pisCommonPayment)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Payment validation has failed: payment product [{}] is incorrect", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), pisCommonPayment.getExternalId(), paymentProduct});
            return ValidationResult.invalid(ErrorType.PIS_403, MessageErrorCode.PRODUCT_INVALID_FOR_PAYMENT);
        }
        return ValidationResult.valid();
    }

    private boolean isPaymentTypeIncorrect(PaymentType paymentType, PisCommonPaymentResponse commonPaymentResponse) {
        return commonPaymentResponse.getPaymentType() != paymentType;
    }

    private boolean isPaymentProductIncorrect(String paymentProduct, PisCommonPaymentResponse commonPaymentResponse) {
        return !commonPaymentResponse.getPaymentProduct().equalsIgnoreCase(paymentProduct);
    }

    @ConstructorProperties(value={"requestProviderService"})
    public GetCommonPaymentByIdResponseValidator(RequestProviderService requestProviderService) {
        this.requestProviderService = requestProviderService;
    }
}

