/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.status;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfoMapper;
import de.adorsys.psd2.xs2a.service.payment.status.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiGetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReadCommonPaymentStatusService
implements ReadPaymentStatusService {
    private static final Logger log = LoggerFactory.getLogger(ReadCommonPaymentStatusService.class);
    private final CommonPaymentSpi commonPaymentSpi;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final RequestProviderService requestProviderService;

    @Override
    public ReadPaymentStatusResponse readPaymentStatus(CommonPaymentData commonPaymentData, SpiContextData spiContextData, @NotNull String encryptedPaymentId) {
        SpiAspspConsentDataProvider aspspConsentDataProvider;
        CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(commonPaymentData);
        SpiPaymentInfo request = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo(commonPayment);
        SpiResponse spiResponse = this.commonPaymentSpi.getPaymentStatusById(spiContextData, request, aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. READ COMMON Payment STATUS failed. Can't get Payment status by ID at SPI level. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), commonPayment.getPaymentId(), errorHolder});
            return new ReadPaymentStatusResponse(errorHolder);
        }
        SpiGetPaymentStatusResponse payload = (SpiGetPaymentStatusResponse)spiResponse.getPayload();
        return new ReadPaymentStatusResponse(payload.getTransactionStatus(), payload.getFundsAvailable());
    }

    @ConstructorProperties(value={"commonPaymentSpi", "spiErrorMapper", "xs2aToSpiPaymentInfoMapper", "cmsToXs2aPaymentMapper", "aspspConsentDataProviderFactory", "requestProviderService"})
    public ReadCommonPaymentStatusService(CommonPaymentSpi commonPaymentSpi, SpiErrorMapper spiErrorMapper, Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, RequestProviderService requestProviderService) {
        this.commonPaymentSpi = commonPaymentSpi;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aToSpiPaymentInfoMapper = xs2aToSpiPaymentInfoMapper;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.requestProviderService = requestProviderService;
    }
}

