/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.authorisation.CancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.PaymentCancellationAuthorisationNeededDecider;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCancelPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CancelPaymentService {
    private static final Logger log = LoggerFactory.getLogger(CancelPaymentService.class);
    private final PaymentCancellationSpi paymentCancellationSpi;
    private final Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService;
    private final PaymentCancellationAuthorisationNeededDecider cancellationScaNeededDecider;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final PaymentCancellationAuthorisationService paymentCancellationAuthorisationService;
    private final RequestProviderService requestProviderService;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    public ResponseObject<CancelPaymentResponse> initiatePaymentCancellation(SpiPayment payment, String encryptedPaymentId, Boolean tppExplicitAuthorisationPreferred, TppRedirectUri tppRedirectUri) {
        SpiContextData spiContextData = this.spiContextDataProvider.provide();
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId);
        SpiResponse spiResponse = this.paymentCancellationSpi.initiatePaymentCancellation(spiContextData, payment, aspspConsentDataProvider);
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Initiate Payment Cancellation has failed. Error msg: {}.", new Object[]{internalRequestId, xRequestId, encryptedPaymentId, errorHolder});
            return ResponseObject.builder().fail(errorHolder).build();
        }
        CancelPaymentResponse cancelPaymentResponse = this.spiToXs2aCancelPaymentMapper.mapToCancelPaymentResponse((SpiPaymentCancellationResponse)spiResponse.getPayload(), payment, encryptedPaymentId);
        TransactionStatus resultStatus = cancelPaymentResponse.getTransactionStatus();
        if (resultStatus != null) {
            this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, resultStatus);
        } else {
            resultStatus = payment.getPaymentStatus();
            cancelPaymentResponse.setTransactionStatus(resultStatus);
        }
        this.updatePaymentStatusAfterSpiService.updatePaymentCancellationTppRedirectUri(encryptedPaymentId, tppRedirectUri);
        if (resultStatus == TransactionStatus.CANC) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Initiate Payment Cancellation has failed. Payment status - CANCELED", new Object[]{internalRequestId, xRequestId, encryptedPaymentId});
            return ResponseObject.builder().body(cancelPaymentResponse).build();
        }
        if (resultStatus.isFinalisedStatus()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Initiate Payment Cancellation has failed. Payment has finalised status", new Object[]{internalRequestId, xRequestId, encryptedPaymentId});
            return ResponseObject.builder().fail(ErrorType.PIS_CANC_405, TppMessageInformation.of(MessageErrorCode.CANCELLATION_INVALID)).build();
        }
        if (resultStatus == TransactionStatus.RCVD || this.cancellationScaNeededDecider.isNoScaRequired(cancelPaymentResponse.isStartAuthorisationRequired())) {
            payment.setPaymentStatus(resultStatus);
            return this.proceedNoScaCancellation(payment, spiContextData, aspspConsentDataProvider, encryptedPaymentId);
        }
        boolean implicitMethod = this.authorisationMethodDecider.isImplicitMethod(tppExplicitAuthorisationPreferred, false);
        if (implicitMethod) {
            Xs2aCreatePisAuthorisationRequest request = new Xs2aCreatePisAuthorisationRequest(encryptedPaymentId, new PsuIdData(null, null, null, null), payment.getPaymentProduct(), payment.getPaymentType().getValue(), null);
            ResponseObject<CancellationAuthorisationResponse> authorisationResponse = this.paymentCancellationAuthorisationService.createPisCancellationAuthorisation(request);
            if (authorisationResponse.hasError()) {
                log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Initiate Payment Cancellation has failed. Can't create implicit authorisation", new Object[]{internalRequestId, xRequestId, encryptedPaymentId});
                return ResponseObject.builder().fail(ErrorType.PIS_CANC_405, TppMessageInformation.of(MessageErrorCode.CANCELLATION_INVALID)).build();
            }
            CancellationAuthorisationResponse authorisationResponseBody = authorisationResponse.getBody();
            cancelPaymentResponse.setAuthorizationId(authorisationResponseBody.getCancellationId());
            cancelPaymentResponse.setScaStatus(authorisationResponseBody.getScaStatus());
        }
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    private ResponseObject<CancelPaymentResponse> proceedNoScaCancellation(SpiPayment payment, SpiContextData spiContextData, SpiAspspConsentDataProvider aspspConsentDataProvider, String encryptedPaymentId) {
        SpiResponse spiResponse = this.paymentCancellationSpi.cancelPaymentWithoutSca(spiContextData, payment, aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Proceed no SCA Cancellation failed. Can't Cancel Payment without SCA at SPI level. Error msg: {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), encryptedPaymentId, errorHolder});
            return ResponseObject.builder().fail(errorHolder).build();
        }
        this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, TransactionStatus.CANC);
        CancelPaymentResponse cancelPaymentResponse = new CancelPaymentResponse();
        cancelPaymentResponse.setTransactionStatus(TransactionStatus.CANC);
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    @ConstructorProperties(value={"paymentCancellationSpi", "updatePaymentStatusAfterSpiService", "cancellationScaNeededDecider", "spiContextDataProvider", "spiErrorMapper", "spiToXs2aCancelPaymentMapper", "authorisationMethodDecider", "paymentCancellationAuthorisationService", "requestProviderService", "aspspConsentDataProviderFactory"})
    public CancelPaymentService(PaymentCancellationSpi paymentCancellationSpi, Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService, PaymentCancellationAuthorisationNeededDecider cancellationScaNeededDecider, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper, AuthorisationMethodDecider authorisationMethodDecider, PaymentCancellationAuthorisationService paymentCancellationAuthorisationService, RequestProviderService requestProviderService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        this.paymentCancellationSpi = paymentCancellationSpi;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.cancellationScaNeededDecider = cancellationScaNeededDecider;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.spiToXs2aCancelPaymentMapper = spiToXs2aCancelPaymentMapper;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.paymentCancellationAuthorisationService = paymentCancellationAuthorisationService;
        this.requestProviderService = requestProviderService;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }
}

