/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAuthenticationObjectToCmsScaMethodMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aToCmsPisCommonPaymentRequestMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aPisCommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aPisCommonPaymentService.class);
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;
    private final RequestProviderService requestProviderService;
    private final Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper;
    private final Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper;

    public CreatePisCommonPaymentResponse createCommonPayment(PisPaymentInfo request) {
        return this.pisCommonPaymentServiceEncrypted.createCommonPayment(request).orElseGet(() -> {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Pis common payment cannot be created, because can't save to cms DB", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getPaymentId()});
            return null;
        });
    }

    public Optional<PisCommonPaymentResponse> getPisCommonPaymentById(String paymentId) {
        return this.pisCommonPaymentServiceEncrypted.getCommonPaymentById(paymentId);
    }

    public void updateSinglePaymentInCommonPayment(SinglePayment singlePayment, PaymentInitiationParameters paymentInitiationParameters, String paymentId) {
        PisCommonPaymentRequest pisCommonPaymentRequest = this.xs2aToCmsPisCommonPaymentRequestMapper.mapToCmsSinglePisCommonPaymentRequest(singlePayment, paymentInitiationParameters.getPaymentProduct());
        this.pisCommonPaymentServiceEncrypted.updateCommonPayment(pisCommonPaymentRequest, paymentId);
    }

    public void updatePeriodicPaymentInCommonPayment(PeriodicPayment periodicPayment, PaymentInitiationParameters paymentInitiationParameters, String paymentId) {
        PisCommonPaymentRequest pisCommonPaymentRequest = this.xs2aToCmsPisCommonPaymentRequestMapper.mapToCmsPeriodicPisCommonPaymentRequest(periodicPayment, paymentInitiationParameters.getPaymentProduct());
        this.pisCommonPaymentServiceEncrypted.updateCommonPayment(pisCommonPaymentRequest, paymentId);
    }

    public void updateBulkPaymentInCommonPayment(BulkPayment bulkPayment, PaymentInitiationParameters paymentInitiationParameters, String paymentId) {
        PisCommonPaymentRequest pisCommonPaymentRequest = this.xs2aToCmsPisCommonPaymentRequestMapper.mapToCmsBulkPisCommonPaymentRequest(bulkPayment, paymentInitiationParameters.getPaymentProduct());
        this.pisCommonPaymentServiceEncrypted.updateCommonPayment(pisCommonPaymentRequest, paymentId);
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.pisCommonPaymentServiceEncrypted.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    public boolean saveAuthenticationMethods(String authorisationId, List<Xs2aAuthenticationObject> methods) {
        return this.pisCommonPaymentServiceEncrypted.saveAuthenticationMethods(authorisationId, this.xs2AAuthenticationObjectToCmsScaMethodMapper.mapToCmsScaMethods(methods));
    }

    public void updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        this.pisCommonPaymentServiceEncrypted.updateScaApproach(authorisationId, scaApproach);
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted", "requestProviderService", "xs2aToCmsPisCommonPaymentRequestMapper", "xs2AAuthenticationObjectToCmsScaMethodMapper"})
    public Xs2aPisCommonPaymentService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted, RequestProviderService requestProviderService, Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper, Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
        this.requestProviderService = requestProviderService;
        this.xs2aToCmsPisCommonPaymentRequestMapper = xs2aToCmsPisCommonPaymentRequestMapper;
        this.xs2AAuthenticationObjectToCmsScaMethodMapper = xs2AAuthenticationObjectToCmsScaMethodMapper;
    }
}

