/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsDownloadResponse;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aDownloadTransactionsMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiTransactionListToXs2aAccountReportMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ValueValidatorService;
import de.adorsys.psd2.xs2a.service.validator.ais.account.DownloadTransactionsReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetTransactionDetailsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetTransactionsReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountTransactionsRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.DownloadTransactionListRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.TransactionsReportByPeriodObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionsDownloadResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransactionService {
    private static final Logger log = LoggerFactory.getLogger(TransactionService.class);
    private final AccountSpi accountSpi;
    private final SpiToXs2aBalanceMapper balanceMapper;
    private final SpiToXs2aAccountReferenceMapper referenceMapper;
    private final SpiTransactionListToXs2aAccountReportMapper transactionsToAccountReportMapper;
    private final SpiToXs2aTransactionMapper spiToXs2aTransactionMapper;
    private final SpiToXs2aDownloadTransactionsMapper spiToXs2aDownloadTransactionsMapper;
    private final ValueValidatorService validatorService;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final Xs2aEventService xs2aEventService;
    private final SpiErrorMapper spiErrorMapper;
    private final GetTransactionsReportValidator getTransactionsReportValidator;
    private final DownloadTransactionsReportValidator downloadTransactionsReportValidator;
    private final GetTransactionDetailsValidator getTransactionDetailsValidator;
    private final RequestProviderService requestProviderService;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final AccountHelperService accountHelperService;

    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(Xs2aTransactionsReportByPeriodRequest request) {
        this.xs2aEventService.recordAisTppRequest(request.getConsentId(), EventType.READ_TRANSACTION_LIST_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(request.getConsentId());
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}]. Get transactions report by period failed. Account consent not found by id", new Object[]{internalRequestId, xRequestId, request.getAccountId(), request.getConsentId()});
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForTransactionsReportByPeriod(request, accountConsent);
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}], WithBalance [{}], RequestUri [{}]. Get transactions report by period - validation failed: {}", new Object[]{internalRequestId, xRequestId, request.getAccountId(), request.getConsentId(), request.isWithBalance(), request.getRequestUri(), validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<SpiTransactionReport> spiResponse = this.getSpiResponseSpiTransactionReport(request, accountConsent);
        if (spiResponse.hasError()) {
            return this.checkSpiResponseForTransactionsReport(request, spiResponse);
        }
        return this.getXs2aTransactionsReportResponseObject(request, accountConsent, (SpiTransactionReport)spiResponse.getPayload());
    }

    public ResponseObject<Transactions> getTransactionDetails(String consentId, String accountId, String transactionId, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_TRANSACTION_DETAILS_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}]. Get transaction details failed. Account consent not found by ID", new Object[]{internalRequestId, xRequestId, accountId, consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForCommonAccountTransactions(accountId, requestUri, accountConsent);
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}], RequestUri [{}]. Get transaction details - validation failed: {}", new Object[]{internalRequestId, xRequestId, accountId, consentId, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<SpiTransaction> spiResponse = this.getSpiResponseSpiTransaction(accountConsent, consentId, accountId, transactionId);
        if (spiResponse.hasError()) {
            return this.checkSpiResponseForTransactions(consentId, accountId, spiResponse);
        }
        return this.getTransactionsResponseObject(consentId, requestUri, accountConsent, (SpiTransaction)spiResponse.getPayload());
    }

    public ResponseObject<Xs2aTransactionsDownloadResponse> downloadTransactions(String consentId, String accountId, String downloadId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.DOWNLOAD_TRANSACTION_LIST_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Account-ID: [{}], Download-ID: [{}]. Download transactions failed. Account consent not found by ID", new Object[]{internalRequestId, xRequestId, consentId, accountId, downloadId});
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForDownloadTransactionRequest(accountConsent);
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Account-ID: [{}], Download-ID: [{}]. Download transactions - validation failed: {}", new Object[]{internalRequestId, xRequestId, consentId, accountId, downloadId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<SpiTransactionsDownloadResponse> spiResponse = this.getSpiResponseSpiTransactionsDownloadResponse(accountConsent, consentId, downloadId);
        if (spiResponse.hasError()) {
            return this.checkSpiResponseForTransactionDownloadResponse(consentId, accountId, downloadId, spiResponse);
        }
        return this.getXs2aTransactionsDownloadResponseResponseObject((SpiTransactionsDownloadResponse)spiResponse.getPayload());
    }

    private ValidationResult getValidationResultForTransactionsReportByPeriod(Xs2aTransactionsReportByPeriodRequest request, AccountConsent accountConsent) {
        TransactionsReportByPeriodObject validatorObject = new TransactionsReportByPeriodObject(accountConsent, request.getAccountId(), request.isWithBalance(), request.getRequestUri(), request.getEntryReferenceFrom(), request.getDeltaList(), request.getAcceptHeader(), request.getBookingStatus());
        return this.getTransactionsReportValidator.validate(validatorObject);
    }

    private ValidationResult getValidationResultForCommonAccountTransactions(String accountId, String requestUri, AccountConsent accountConsent) {
        CommonAccountTransactionsRequestObject validatorObject = new CommonAccountTransactionsRequestObject(accountConsent, accountId, requestUri);
        return this.getTransactionDetailsValidator.validate(validatorObject);
    }

    private ValidationResult getValidationResultForDownloadTransactionRequest(AccountConsent accountConsent) {
        DownloadTransactionListRequestObject validatorObject = new DownloadTransactionListRequestObject(accountConsent);
        return this.downloadTransactionsReportValidator.validate(validatorObject);
    }

    @NotNull
    private SpiResponse<SpiTransactionReport> getSpiResponseSpiTransactionReport(Xs2aTransactionsReportByPeriodRequest request, AccountConsent accountConsent) {
        LocalDate dateFrom = request.getDateFrom();
        LocalDate dateToChecked = Optional.ofNullable(request.getDateTo()).orElseGet(LocalDate::now);
        this.validatorService.validateAccountIdPeriod(request.getAccountId(), dateFrom, dateToChecked);
        boolean isTransactionsShouldContainBalances = !this.aspspProfileService.isTransactionsWithoutBalancesSupported() || request.isWithBalance();
        return this.accountSpi.requestTransactionsForAccount(this.accountHelperService.getSpiContextData(), request.getAcceptHeader(), isTransactionsShouldContainBalances, dateFrom, dateToChecked, request.getBookingStatus(), this.getRequestedAccountReference(accountConsent, request.getAccountId()), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getConsentId()));
    }

    private SpiAccountReference getRequestedAccountReference(AccountConsent accountConsent, String accountId) {
        Xs2aAccountAccess access = accountConsent.getAccess();
        return this.accountHelperService.findAccountReference(access.getAllPsd2(), access.getTransactions(), accountId);
    }

    private ResponseObject<Xs2aTransactionsReport> checkSpiResponseForTransactionsReport(Xs2aTransactionsReportByPeriodRequest request, SpiResponse<SpiTransactionReport> spiResponse) {
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (((TppMessage)spiResponse.getErrors().get(0)).getErrorCode() == MessageErrorCode.SERVICE_NOT_SUPPORTED) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get transactions report by period failed: requested content-type not json or text.", new Object[]{internalRequestId, xRequestId, request.getAccountId(), request.getConsentId()});
            return ResponseObject.builder().fail(ErrorType.AIS_406, TppMessageInformation.of(MessageErrorCode.REQUESTED_FORMATS_INVALID)).build();
        }
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
        log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get transactions report by period failed: Request transactions for account fail at SPI level: {}", new Object[]{internalRequestId, xRequestId, request.getAccountId(), request.getConsentId(), errorHolder});
        return ResponseObject.builder().fail(errorHolder).build();
    }

    @NotNull
    private SpiResponse<SpiTransaction> getSpiResponseSpiTransaction(AccountConsent accountConsent, String consentId, String accountId, String transactionId) {
        this.validatorService.validateAccountIdTransactionId(accountId, transactionId);
        return this.accountSpi.requestTransactionForAccountByTransactionId(this.accountHelperService.getSpiContextData(), transactionId, this.getRequestedAccountReference(accountConsent, accountId), this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    private ResponseObject<Transactions> checkSpiResponseForTransactions(String consentId, String accountId, SpiResponse<SpiTransaction> spiResponse) {
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
        log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get transaction details failed: Request transactions for account fail at SPI level: {}", new Object[]{internalRequestId, xRequestId, accountId, consentId, errorHolder});
        return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
    }

    @NotNull
    private SpiResponse<SpiTransactionsDownloadResponse> getSpiResponseSpiTransactionsDownloadResponse(AccountConsent accountConsent, String consentId, String downloadId) {
        String decodedDownloadId = new String(Base64.getUrlDecoder().decode(downloadId));
        return this.accountSpi.requestTransactionsByDownloadLink(this.accountHelperService.getSpiContextData(), this.consentMapper.mapToSpiAccountConsent(accountConsent), decodedDownloadId, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    private ResponseObject<Xs2aTransactionsDownloadResponse> checkSpiResponseForTransactionDownloadResponse(String consentId, String accountId, String downloadId, SpiResponse<SpiTransactionsDownloadResponse> spiResponse) {
        UUID xRequestId = this.requestProviderService.getRequestId();
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
        log.info("X-Request-ID: [{}], Consent-ID [{}], Account-ID: [{}], Download-ID: [{}]. Download transactions failed: couldn't get download transactions stream by link.", new Object[]{xRequestId, consentId, accountId, downloadId});
        return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
    }

    @NotNull
    private ResponseObject<Xs2aTransactionsReport> getXs2aTransactionsReportResponseObject(Xs2aTransactionsReportByPeriodRequest request, AccountConsent accountConsent, SpiTransactionReport spiTransactionReport) {
        Xs2aTransactionsReport transactionsReport = this.mapToTransactionsReport(request, accountConsent, spiTransactionReport);
        ResponseObject<Xs2aTransactionsReport> response = ResponseObject.builder().body(transactionsReport).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), request.getConsentId(), this.accountHelperService.createActionStatus(request.isWithBalance(), TypeAccess.TRANSACTION, response), request.getRequestUri(), this.accountHelperService.needsToUpdateUsage(accountConsent));
        return response;
    }

    @NotNull
    private Xs2aTransactionsReport mapToTransactionsReport(Xs2aTransactionsReportByPeriodRequest request, AccountConsent accountConsent, SpiTransactionReport spiTransactionReport) {
        Xs2aAccountReport report = this.transactionsToAccountReportMapper.mapToXs2aAccountReport(request.getBookingStatus(), spiTransactionReport.getTransactions(), spiTransactionReport.getTransactionsRaw()).orElse(null);
        Xs2aTransactionsReport transactionsReport = this.getXs2aTransactionsReport(report, this.getRequestedAccountReference(accountConsent, request.getAccountId()), spiTransactionReport);
        if (spiTransactionReport.getDownloadId() != null) {
            String encodedDownloadId = Base64.getUrlEncoder().encodeToString(spiTransactionReport.getDownloadId().getBytes());
            transactionsReport.setDownloadId(encodedDownloadId);
        }
        return transactionsReport;
    }

    private Xs2aTransactionsReport getXs2aTransactionsReport(Xs2aAccountReport report, SpiAccountReference requestedAccountReference, SpiTransactionReport spiTransactionReport) {
        Xs2aTransactionsReport transactionsReport = new Xs2aTransactionsReport();
        transactionsReport.setAccountReport(report);
        transactionsReport.setAccountReference(this.referenceMapper.mapToXs2aAccountReference(requestedAccountReference));
        transactionsReport.setBalances(this.balanceMapper.mapToXs2aBalanceList(spiTransactionReport.getBalances()));
        transactionsReport.setResponseContentType(spiTransactionReport.getResponseContentType());
        return transactionsReport;
    }

    @NotNull
    private ResponseObject<Transactions> getTransactionsResponseObject(String consentId, String requestUri, AccountConsent accountConsent, SpiTransaction spiTransaction) {
        Transactions transactions = this.spiToXs2aTransactionMapper.mapToXs2aTransaction(spiTransaction);
        ResponseObject<Transactions> response = ResponseObject.builder().body(transactions).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.accountHelperService.createActionStatus(false, TypeAccess.TRANSACTION, response), requestUri, this.accountHelperService.needsToUpdateUsage(accountConsent));
        return response;
    }

    private ResponseObject<Xs2aTransactionsDownloadResponse> getXs2aTransactionsDownloadResponseResponseObject(SpiTransactionsDownloadResponse spiTransactionsDownloadResponse) {
        Xs2aTransactionsDownloadResponse transactionsDownloadResponse = this.spiToXs2aDownloadTransactionsMapper.mapToXs2aTransactionsDownloadResponse(spiTransactionsDownloadResponse);
        return ResponseObject.builder().body(transactionsDownloadResponse).build();
    }

    @ConstructorProperties(value={"accountSpi", "balanceMapper", "referenceMapper", "transactionsToAccountReportMapper", "spiToXs2aTransactionMapper", "spiToXs2aDownloadTransactionsMapper", "validatorService", "aisConsentService", "consentMapper", "tppService", "aspspProfileService", "xs2aEventService", "spiErrorMapper", "getTransactionsReportValidator", "downloadTransactionsReportValidator", "getTransactionDetailsValidator", "requestProviderService", "aspspConsentDataProviderFactory", "accountHelperService"})
    public TransactionService(AccountSpi accountSpi, SpiToXs2aBalanceMapper balanceMapper, SpiToXs2aAccountReferenceMapper referenceMapper, SpiTransactionListToXs2aAccountReportMapper transactionsToAccountReportMapper, SpiToXs2aTransactionMapper spiToXs2aTransactionMapper, SpiToXs2aDownloadTransactionsMapper spiToXs2aDownloadTransactionsMapper, ValueValidatorService validatorService, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, AspspProfileServiceWrapper aspspProfileService, Xs2aEventService xs2aEventService, SpiErrorMapper spiErrorMapper, GetTransactionsReportValidator getTransactionsReportValidator, DownloadTransactionsReportValidator downloadTransactionsReportValidator, GetTransactionDetailsValidator getTransactionDetailsValidator, RequestProviderService requestProviderService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AccountHelperService accountHelperService) {
        this.accountSpi = accountSpi;
        this.balanceMapper = balanceMapper;
        this.referenceMapper = referenceMapper;
        this.transactionsToAccountReportMapper = transactionsToAccountReportMapper;
        this.spiToXs2aTransactionMapper = spiToXs2aTransactionMapper;
        this.spiToXs2aDownloadTransactionsMapper = spiToXs2aDownloadTransactionsMapper;
        this.validatorService = validatorService;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.aspspProfileService = aspspProfileService;
        this.xs2aEventService = xs2aEventService;
        this.spiErrorMapper = spiErrorMapper;
        this.getTransactionsReportValidator = getTransactionsReportValidator;
        this.downloadTransactionsReportValidator = downloadTransactionsReportValidator;
        this.getTransactionDetailsValidator = getTransactionDetailsValidator;
        this.requestProviderService = requestProviderService;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.accountHelperService = accountHelperService;
    }
}

