/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeDeserializer
extends StdDeserializer<LocalDateTime> {
    private static final Logger log = LoggerFactory.getLogger(DateTimeDeserializer.class);
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS")).appendOptional(DateTimeFormatter.ofPattern("'Z'")).appendOptional(DateTimeFormatter.ofPattern("XXX")).toFormatter();

    public DateTimeDeserializer() {
        super(LocalDateTime.class);
    }

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            String date = jsonParser.getText();
            return LocalDateTime.parse(date, this.formatter);
        }
        catch (IOException | DateTimeParseException e) {
            log.error("Unsupported dateTime format!");
            return null;
        }
    }
}

