/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.path;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.path.TransactionListDownloadPathParamsValidator;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class TransactionListDownloadPathParamsValidatorImpl
implements TransactionListDownloadPathParamsValidator {
    private static final String BASE64_REGEX = "^(?:[A-Za-z0-9-_]{4})*(?:[A-Za-z0-9-_]{2}==|[A-Za-z0-9-_]{3}=)?$";
    private static final Pattern PATTERN = Pattern.compile("^(?:[A-Za-z0-9-_]{4})*(?:[A-Za-z0-9-_]{2}==|[A-Za-z0-9-_]{3}=)?$");
    private static final String DOWNLOAD_ID_PATH_PARAMETER_NAME = "download-id";
    private static final String ERROR_TEXT_WRONG_PATH_PARAMETER = String.format("Path parameter '%s' has to be represented in Base64", "download-id");
    private final ErrorBuildingService errorBuildingService;

    public TransactionListDownloadPathParamsValidatorImpl(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }

    @Override
    public void validate(Map<String, String> queryParameterMap, MessageError messageError) {
        String downloadId = queryParameterMap.get(DOWNLOAD_ID_PATH_PARAMETER_NAME);
        if (this.isNonValid(downloadId)) {
            this.errorBuildingService.enrichMessageError(messageError, ERROR_TEXT_WRONG_PATH_PARAMETER);
        }
    }

    private boolean isNonValid(String base64) {
        return !PATTERN.matcher(base64).matches();
    }
}

