/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.domain.address.Xs2aCountryCode;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentMapper {
    private ObjectMapper objectMapper;
    private PurposeCodeMapper purposeCodeMapper;
    private RemittanceMapper remittanceMapper;

    @Autowired
    public PaymentMapper(ObjectMapper objectMapper, PurposeCodeMapper purposeCodeMapper, RemittanceMapper remittanceMapper) {
        this.objectMapper = objectMapper;
        this.purposeCodeMapper = purposeCodeMapper;
        this.remittanceMapper = remittanceMapper;
    }

    public SinglePayment getSinglePayment(Object body) {
        return this.mapToXs2aSinglePayment(this.convertPayment(body, PaymentInitiationJson.class));
    }

    public PeriodicPayment getPeriodicPayment(Object body) {
        return this.mapToXs2aPeriodicPayment(this.convertPayment(body, PeriodicPaymentInitiationJson.class));
    }

    public BulkPayment getBulkPayment(Object body) {
        return this.mapToXs2aBulkPayment(this.convertPayment(body, BulkPaymentInitiationJson.class));
    }

    private <R> R convertPayment(Object payment, Class<R> clazz) {
        return (R)this.objectMapper.convertValue(payment, clazz);
    }

    private SinglePayment mapToXs2aSinglePayment(PaymentInitiationJson paymentRequest) {
        SinglePayment payment = new SinglePayment();
        payment.setEndToEndIdentification(paymentRequest.getEndToEndIdentification());
        payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
        payment.setInstructedAmount(this.mapToXs2aAmount(paymentRequest.getInstructedAmount()));
        payment.setCreditorAccount(this.mapToXs2aAccountReference(paymentRequest.getCreditorAccount()));
        payment.setCreditorAgent(paymentRequest.getCreditorAgent());
        payment.setCreditorId(paymentRequest.getCreditorId());
        payment.setCreditorName(paymentRequest.getCreditorName());
        payment.setCreditorAddress(this.mapToXs2aAddress(paymentRequest.getCreditorAddress()));
        payment.setRemittanceInformationUnstructured(paymentRequest.getRemittanceInformationUnstructured());
        payment.setRequestedExecutionDate(paymentRequest.getRequestedExecutionDate());
        payment.setUltimateDebtor(paymentRequest.getUltimateDebtor());
        payment.setUltimateCreditor(paymentRequest.getUltimateCreditor());
        payment.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(paymentRequest.getPurposeCode()));
        payment.setRemittanceInformationStructured(this.remittanceMapper.mapToToRemittance(paymentRequest.getRemittanceInformationStructured()));
        return payment;
    }

    private PeriodicPayment mapToXs2aPeriodicPayment(PeriodicPaymentInitiationJson paymentRequest) {
        PeriodicPayment payment = new PeriodicPayment();
        payment.setEndToEndIdentification(paymentRequest.getEndToEndIdentification());
        payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
        payment.setInstructedAmount(this.mapToXs2aAmount(paymentRequest.getInstructedAmount()));
        payment.setCreditorAccount(this.mapToXs2aAccountReference(paymentRequest.getCreditorAccount()));
        payment.setCreditorAgent(paymentRequest.getCreditorAgent());
        payment.setCreditorId(paymentRequest.getCreditorId());
        payment.setCreditorName(paymentRequest.getCreditorName());
        payment.setCreditorAddress(this.mapToXs2aAddress(paymentRequest.getCreditorAddress()));
        payment.setRemittanceInformationUnstructured(paymentRequest.getRemittanceInformationUnstructured());
        payment.setRequestedExecutionDate(LocalDate.now());
        payment.setRequestedExecutionTime(OffsetDateTime.now().plusHours(1L));
        payment.setStartDate(paymentRequest.getStartDate());
        payment.setExecutionRule(this.mapToPisExecutionRule(paymentRequest.getExecutionRule()).orElse(null));
        payment.setEndDate(paymentRequest.getEndDate());
        payment.setFrequency(this.mapToFrequencyCode(paymentRequest.getFrequency()));
        payment.setDayOfExecution(this.mapToPisDayOfExecution(paymentRequest.getDayOfExecution()).orElse(null));
        payment.setUltimateDebtor(paymentRequest.getUltimateDebtor());
        payment.setUltimateCreditor(paymentRequest.getUltimateCreditor());
        payment.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(paymentRequest.getPurposeCode()));
        payment.setRemittanceInformationStructured(this.remittanceMapper.mapToToRemittance(paymentRequest.getRemittanceInformationStructured()));
        return payment;
    }

    private AccountReference mapToXs2aAccountReference(Object accountReference) {
        return (AccountReference)this.objectMapper.convertValue(accountReference, AccountReference.class);
    }

    private Optional<PisExecutionRule> mapToPisExecutionRule(ExecutionRule rule) {
        return Optional.ofNullable(rule).map(ExecutionRule::toString).flatMap(PisExecutionRule::getByValue);
    }

    private de.adorsys.psd2.xs2a.core.pis.FrequencyCode mapToFrequencyCode(FrequencyCode frequency) {
        return de.adorsys.psd2.xs2a.core.pis.FrequencyCode.valueOf((String)frequency.name());
    }

    private Optional<PisDayOfExecution> mapToPisDayOfExecution(DayOfExecution dayOfExecution) {
        return Optional.ofNullable(dayOfExecution).map(DayOfExecution::toString).flatMap(PisDayOfExecution::getByValue);
    }

    private Xs2aAmount mapToXs2aAmount(Amount amount) {
        return Optional.ofNullable(amount).map(a -> {
            Xs2aAmount amountTarget = new Xs2aAmount();
            amountTarget.setAmount(a.getAmount());
            amountTarget.setCurrency(this.getCurrencyByCode(a.getCurrency()));
            return amountTarget;
        }).orElse(null);
    }

    private Currency getCurrencyByCode(String code) {
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            try {
                return Currency.getInstance(code);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private Xs2aAddress mapToXs2aAddress(Address address) {
        return Optional.ofNullable(address).map(a -> {
            Xs2aAddress targetAddress = new Xs2aAddress();
            targetAddress.setStreetName(a.getStreetName());
            targetAddress.setBuildingNumber(a.getBuildingNumber());
            targetAddress.setTownName(a.getTownName());
            targetAddress.setPostCode(a.getPostCode());
            targetAddress.setCountry(new Xs2aCountryCode(a.getCountry()));
            return targetAddress;
        }).orElse(null);
    }

    private BulkPayment mapToXs2aBulkPayment(BulkPaymentInitiationJson paymentRequest) {
        BulkPayment bulkPayment = new BulkPayment();
        bulkPayment.setBatchBookingPreferred(paymentRequest.getBatchBookingPreferred());
        bulkPayment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
        bulkPayment.setRequestedExecutionDate(paymentRequest.getRequestedExecutionDate());
        bulkPayment.setRequestedExecutionTime(paymentRequest.getRequestedExecutionTime());
        bulkPayment.setPayments(this.mapBulkPaymentToSinglePayments(paymentRequest));
        return bulkPayment;
    }

    private List<SinglePayment> mapBulkPaymentToSinglePayments(BulkPaymentInitiationJson paymentRequest) {
        return paymentRequest.getPayments().stream().map(p -> {
            SinglePayment payment = new SinglePayment();
            payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
            payment.setRequestedExecutionDate(paymentRequest.getRequestedExecutionDate());
            payment.setEndToEndIdentification(p.getEndToEndIdentification());
            payment.setInstructedAmount(this.mapToXs2aAmount(p.getInstructedAmount()));
            payment.setCreditorAccount(this.mapToXs2aAccountReference(p.getCreditorAccount()));
            payment.setCreditorAgent(p.getCreditorAgent());
            payment.setCreditorName(p.getCreditorName());
            payment.setCreditorAddress(this.mapToXs2aAddress(p.getCreditorAddress()));
            payment.setRemittanceInformationUnstructured(p.getRemittanceInformationUnstructured());
            payment.setRequestedExecutionTime(paymentRequest.getRequestedExecutionTime());
            payment.setUltimateDebtor(p.getUltimateDebtor());
            payment.setUltimateCreditor(p.getUltimateCreditor());
            payment.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(p.getPurposeCode()));
            payment.setRemittanceInformationStructured(this.remittanceMapper.mapToToRemittance(p.getRemittanceInformationStructured()));
            return payment;
        }).collect(Collectors.toList());
    }
}

