/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.PurposeCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.DateFieldValidator;
import de.adorsys.psd2.xs2a.web.validator.body.TppRedirectUriBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.payment.PaymentBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.PaymentTypeValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.PaymentTypeValidatorContext;
import de.adorsys.psd2.xs2a.web.validator.body.raw.FieldExtractor;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateFields;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class PaymentBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements PaymentBodyValidator {
    private static final Logger log = LoggerFactory.getLogger(PaymentBodyValidatorImpl.class);
    private static final String PAYMENT_SERVICE_PATH_VAR = "payment-service";
    private static final String PAYMENT_PRODUCT_PATH_VAR = "payment-product";
    private static final String PURPOSE_CODE_FIELD_NAME = "purposeCode";
    private static final String FREQUENCY_FIELD_NAME = "frequency";
    private static final String BODY_DESERIALIZATION_ERROR = "Cannot deserialize the request body";
    private static final String PERIODIC_PAYMENT_PATH_VAR = "periodic-payments";
    static final String PURPOSE_CODE_ERROR_FORMAT = "Field 'purposeCode' has wrong value";
    static final String NO_FREQUENCY_ERROR_FORMAT = "Field 'frequency' should not be null";
    static final String WRONG_FREQUENCY_FORMAT = "Wrong format for field 'frequency'";
    private PaymentTypeValidatorContext paymentTypeValidatorContext;
    private DateFieldValidator dateFieldValidator;
    private final JsonConverter jsonConverter;
    private TppRedirectUriBodyValidatorImpl tppRedirectUriBodyValidator;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final FieldExtractor fieldExtractor;

    @Autowired
    public PaymentBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, PaymentTypeValidatorContext paymentTypeValidatorContext, StandardPaymentProductsResolver standardPaymentProductsResolver, JsonConverter jsonConverter, TppRedirectUriBodyValidatorImpl tppRedirectUriBodyValidator, DateFieldValidator dateFieldValidator, FieldExtractor fieldExtractor) {
        super(errorBuildingService, objectMapper);
        this.paymentTypeValidatorContext = paymentTypeValidatorContext;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.dateFieldValidator = dateFieldValidator;
        this.jsonConverter = jsonConverter;
        this.tppRedirectUriBodyValidator = tppRedirectUriBodyValidator;
        this.fieldExtractor = fieldExtractor;
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        if (this.isRawPaymentProduct(this.getPathParameters(request))) {
            log.info("Raw payment product is detected.");
            return;
        }
        super.validate(request, messageError);
    }

    @Override
    public void validateBodyFields(HttpServletRequest request, MessageError messageError) {
        this.tppRedirectUriBodyValidator.validate(request, messageError);
        Optional<Object> bodyOptional = this.mapBodyToInstance(request, messageError, Object.class);
        if (!bodyOptional.isPresent()) {
            return;
        }
        this.validateInitiatePaymentBody(bodyOptional.get(), this.getPathParameters(request), messageError);
    }

    @Override
    public void validateRawData(HttpServletRequest request, MessageError messageError) {
        this.dateFieldValidator.validateDayOfExecution(request, messageError);
        this.dateFieldValidator.validateDateFormat(request, Xs2aRequestBodyDateFields.PAYMENT_DATE_FIELDS.getDateFields(), messageError);
        this.validateFrequencyForPeriodicPayment(request, messageError);
        this.validatePurposeCodes(request, messageError);
    }

    private void validateFrequencyForPeriodicPayment(HttpServletRequest request, MessageError messageError) {
        Optional<String> frequencyOptional = this.fieldExtractor.extractField(request, FREQUENCY_FIELD_NAME, messageError);
        boolean isPeriodicPayment = this.getPathParameters(request).get(PAYMENT_SERVICE_PATH_VAR).equals(PERIODIC_PAYMENT_PATH_VAR);
        if (isPeriodicPayment) {
            if (!frequencyOptional.isPresent()) {
                this.errorBuildingService.enrichMessageError(messageError, NO_FREQUENCY_ERROR_FORMAT);
            } else if (FrequencyCode.fromValue((String)frequencyOptional.get()) == null) {
                this.errorBuildingService.enrichMessageError(messageError, WRONG_FREQUENCY_FORMAT);
            }
        }
    }

    private void validateInitiatePaymentBody(Object body, Map<String, String> pathParametersMap, MessageError messageError) {
        String paymentService = pathParametersMap.get(PAYMENT_SERVICE_PATH_VAR);
        Optional<PaymentTypeValidator> validator = this.paymentTypeValidatorContext.getValidator(paymentService);
        if (!validator.isPresent()) {
            throw new IllegalArgumentException("Unsupported payment service");
        }
        validator.get().validate(body, messageError);
    }

    private boolean isRawPaymentProduct(Map<String, String> pathParametersMap) {
        String paymentProduct = pathParametersMap.get(PAYMENT_PRODUCT_PATH_VAR);
        return this.standardPaymentProductsResolver.isRawPaymentProduct(paymentProduct);
    }

    private void validatePurposeCodes(HttpServletRequest request, MessageError messageError) {
        List<String> purposeCodes = this.extractPurposeCodes(request, messageError);
        boolean isPurposeCodeInvalid = purposeCodes.stream().map(PurposeCode::fromValue).anyMatch(Objects::isNull);
        if (isPurposeCodeInvalid) {
            this.enrichFormatMessageError(PURPOSE_CODE_ERROR_FORMAT, messageError);
        }
    }

    private void enrichFormatMessageError(String message, MessageError messageError) {
        this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, message));
    }

    private List<String> extractPurposeCodes(HttpServletRequest request, MessageError messageError) {
        ArrayList<String> purposeCodes = new ArrayList<String>();
        try {
            purposeCodes.addAll(this.jsonConverter.toJsonGetValuesForField((InputStream)request.getInputStream(), PURPOSE_CODE_FIELD_NAME));
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, BODY_DESERIALIZATION_ERROR);
        }
        return purposeCodes;
    }

    private Map<String, String> getPathParameters(HttpServletRequest request) {
        return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
    }
}

