/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.BodyValidator;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TppRedirectUriBodyValidatorImpl
implements BodyValidator {
    static final String ERROR_TEXT_ABSENT_HEADER = "Header '%s' is missing in request";
    static final String ERROR_TEXT_NULL_HEADER = "Header '%s' should not be null";
    static final String ERROR_TEXT_BLANK_HEADER = "Header '%s' should not be blank";
    private final ScaApproachResolver scaApproachResolver;
    private final ErrorBuildingService errorBuildingService;

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        if (this.isRedirectScaApproach()) {
            String tppRedirectUriHeader = request.getHeader("tpp-redirect-uri");
            Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(String::toLowerCase, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
            if (!headers.containsKey("tpp-redirect-uri")) {
                this.errorBuildingService.enrichMessageError(messageError, String.format(ERROR_TEXT_ABSENT_HEADER, "tpp-redirect-uri"));
            } else if (Objects.isNull(tppRedirectUriHeader)) {
                this.errorBuildingService.enrichMessageError(messageError, String.format(ERROR_TEXT_NULL_HEADER, "tpp-redirect-uri"));
            } else if (StringUtils.isBlank((CharSequence)tppRedirectUriHeader)) {
                this.errorBuildingService.enrichMessageError(messageError, String.format(ERROR_TEXT_BLANK_HEADER, "tpp-redirect-uri"));
            }
        }
    }

    private boolean isRedirectScaApproach() {
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        return ScaApproach.REDIRECT == scaApproach;
    }

    @ConstructorProperties(value={"scaApproachResolver", "errorBuildingService"})
    public TppRedirectUriBodyValidatorImpl(ScaApproachResolver scaApproachResolver, ErrorBuildingService errorBuildingService) {
        this.scaApproachResolver = scaApproachResolver;
        this.errorBuildingService = errorBuildingService;
    }
}

