/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AmountValidator {
    private static final String CORRECT_AMOUNT_REGEX = "-?[0-9]{1,14}([.]{1}[0-9]{1,3})?";
    private final ErrorBuildingService errorBuildingService;

    public void validateAmount(String amount, MessageError messageError) {
        if (amount == null) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'amount' should not be null");
        } else if (StringUtils.isBlank((CharSequence)amount)) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'amount' should not be empty");
        } else if (!Pattern.matches(CORRECT_AMOUNT_REGEX, amount)) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'amount' has wrong format");
        }
    }

    @ConstructorProperties(value={"errorBuildingService"})
    public AmountValidator(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }
}

