/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;

public class UpdatePisAuthorisationLinks
extends AbstractLinks {
    public UpdatePisAuthorisationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, Xs2aUpdatePisCommonPaymentPsuDataResponse response, Xs2aCreatePisAuthorisationRequest createRequest) {
        super(httpUrl);
        ScaStatus scaStatus = response.getScaStatus();
        HrefType authorisationLink = this.buildAuthorisationLink(response, createRequest);
        this.setScaStatus(authorisationLink);
        if (this.isScaStatusMethodAuthenticated(scaStatus)) {
            this.setSelectAuthenticationMethod(authorisationLink);
        } else if (this.isScaStatusMethodSelected(response.getChosenScaMethod(), scaStatus) && scaApproachResolver.getInitiationScaApproach(response.getAuthorisationId()) == ScaApproach.EMBEDDED) {
            this.setAuthoriseTransaction(authorisationLink);
        } else if (this.isScaStatusMethodIdentified(scaStatus)) {
            this.setUpdatePsuAuthentication(authorisationLink);
        }
    }

    private HrefType buildAuthorisationLink(Xs2aUpdatePisCommonPaymentPsuDataResponse response, Xs2aCreatePisAuthorisationRequest createRequest) {
        return this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", createRequest.getPaymentService(), createRequest.getPaymentProduct(), createRequest.getPaymentId(), response.getAuthorisationId());
    }
}

