/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.MethodValidator;
import de.adorsys.psd2.xs2a.web.validator.MethodValidatorController;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class RequestValidationInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(RequestValidationInterceptor.class);
    private final ErrorBuildingService errorBuildingService;
    private final MethodValidatorController methodValidatorController;
    private final RequestProviderService requestProviderService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.isRequestValid(request, response, handler);
    }

    private boolean isRequestValid(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        MessageError initialMessageError = new MessageError();
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String methodName = handlerMethod.getMethod().getName();
            MethodValidator methodValidator = this.methodValidatorController.getMethod(methodName);
            methodValidator.validate(request, initialMessageError);
            if (!initialMessageError.getTppMessages().isEmpty()) {
                log.warn("InR-ID: [{}], X-Request-ID: [{}]. Validation of incoming request failed. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestIdString(), initialMessageError});
                this.errorBuildingService.buildErrorResponse(response, initialMessageError);
                return false;
            }
        }
        return true;
    }

    @ConstructorProperties(value={"errorBuildingService", "methodValidatorController", "requestProviderService"})
    public RequestValidationInterceptor(ErrorBuildingService errorBuildingService, MethodValidatorController methodValidatorController, RequestProviderService requestProviderService) {
        this.errorBuildingService = errorBuildingService;
        this.methodValidatorController = methodValidatorController;
        this.requestProviderService = requestProviderService;
    }
}

