/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.header;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class PaymentInitiationHeadersBuilder {
    private final ScaApproachResolver scaApproachResolver;

    public ResponseHeaders buildInitiatePaymentHeaders(@Nullable String authorisationId, @NotNull String selfLink) {
        if (authorisationId == null) {
            return ResponseHeaders.builder().location(selfLink).build();
        }
        ScaApproach scaApproach = this.scaApproachResolver.getInitiationScaApproach(authorisationId);
        return ResponseHeaders.builder().aspspScaApproach(scaApproach).location(selfLink).build();
    }

    public ResponseHeaders buildErrorInitiatePaymentHeaders() {
        return this.buildScaApproachHeader(this.scaApproachResolver.resolveScaApproach());
    }

    public ResponseHeaders buildStartPaymentAuthorisationHeaders(@NotNull String authorisationId) {
        return this.buildHeadersForExistingAuthorisation(authorisationId);
    }

    public ResponseHeaders buildErrorStartPaymentAuthorisationHeaders() {
        return this.buildScaApproachHeader(this.scaApproachResolver.resolveScaApproach());
    }

    public ResponseHeaders buildUpdatePaymentInitiationPsuDataHeaders(@NotNull String authorisationId) {
        return this.buildHeadersForExistingAuthorisation(authorisationId);
    }

    private ResponseHeaders buildHeadersForExistingAuthorisation(String authorisationId) {
        ScaApproach authorisationScaApproach = this.scaApproachResolver.getInitiationScaApproach(authorisationId);
        return this.buildScaApproachHeader(authorisationScaApproach);
    }

    private ResponseHeaders buildScaApproachHeader(ScaApproach scaApproach) {
        return ResponseHeaders.builder().aspspScaApproach(scaApproach).build();
    }

    @ConstructorProperties(value={"scaApproachResolver"})
    public PaymentInitiationHeadersBuilder(ScaApproachResolver scaApproachResolver) {
        this.scaApproachResolver = scaApproachResolver;
    }
}

