/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.AccountApi;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsDownloadResponse;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.ais.AccountDetailsService;
import de.adorsys.psd2.xs2a.service.ais.AccountListService;
import de.adorsys.psd2.xs2a.service.ais.BalanceService;
import de.adorsys.psd2.xs2a.service.ais.TransactionService;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import de.adorsys.psd2.xs2a.web.filter.TppErrorMessage;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the account information", tags={"Account Information Service (AIS)"})
public class AccountController
implements AccountApi {
    private static final Logger log = LoggerFactory.getLogger(AccountController.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final BalanceService balanceService;
    private final AccountListService accountListService;
    private final AccountDetailsService accountDetailsService;
    private final TransactionService transactionService;
    private final ResponseMapper responseMapper;
    private final AccountModelMapper accountModelMapper;
    private final ResponseErrorMapper responseErrorMapper;

    public ResponseEntity getAccountList(UUID xRequestID, String consentID, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAccountListHolder> accountList = this.accountListService.getAccountList(consentID, Optional.ofNullable(withBalance).orElse(false), this.trimEndingSlash(this.request.getRequestURI()));
        return accountList.hasError() ? this.responseErrorMapper.generateErrorResponse(accountList.getError()) : this.responseMapper.ok(accountList, this.accountModelMapper::mapToAccountList);
    }

    public ResponseEntity readAccountDetails(String accountId, UUID xRequestID, String consentID, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAccountDetailsHolder> accountDetails = this.accountDetailsService.getAccountDetails(consentID, accountId, Optional.ofNullable(withBalance).orElse(false), this.trimEndingSlash(this.request.getRequestURI()));
        return accountDetails.hasError() ? this.responseErrorMapper.generateErrorResponse(accountDetails.getError()) : this.responseMapper.ok(accountDetails, this.accountModelMapper::mapToInlineResponse200);
    }

    public ResponseEntity getBalances(String accountId, UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aBalancesReport> balancesReport = this.balanceService.getBalancesReport(consentID, accountId, this.trimEndingSlash(this.request.getRequestURI()));
        return balancesReport.hasError() ? this.responseErrorMapper.generateErrorResponse(balancesReport.getError()) : this.responseMapper.ok(balancesReport, this.accountModelMapper::mapToBalance);
    }

    public ResponseEntity getTransactionList(String accountId, String bookingStatus, UUID xRequestID, String consentID, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, Boolean deltaList, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        Xs2aTransactionsReportByPeriodRequest xs2aTransactionsReportByPeriodRequest = new Xs2aTransactionsReportByPeriodRequest(consentID, accountId, this.request.getHeader("accept"), BooleanUtils.isTrue((Boolean)withBalance), dateFrom, dateTo, BookingStatus.forValue((String)bookingStatus), this.trimEndingSlash(this.request.getRequestURI()), entryReferenceFrom, deltaList);
        ResponseObject<Xs2aTransactionsReport> transactionsReport = this.transactionService.getTransactionsReportByPeriod(xs2aTransactionsReportByPeriodRequest);
        if (transactionsReport.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(transactionsReport.getError());
        }
        if (transactionsReport.getBody().isResponseContentTypeJson()) {
            return this.responseMapper.ok(transactionsReport, this.accountModelMapper::mapToTransactionsResponse200Json);
        }
        return this.responseMapper.ok(transactionsReport, this.accountModelMapper::mapToTransactionsResponseRaw);
    }

    @GetMapping(value={"/v1/accounts/{account-id}/transactions/download/{download-id}"})
    public void downloadTransactions(@RequestHeader(value="X-Request-ID") UUID xRequestId, @RequestHeader(value="Consent-ID") String consentId, @PathVariable(value="account-id") String accountId, @PathVariable(value="download-id") String downloadId) {
        ResponseObject<Xs2aTransactionsDownloadResponse> downloadTransactionsResponse = this.transactionService.downloadTransactions(consentId, accountId, downloadId);
        if (downloadTransactionsResponse.hasError()) {
            MessageError error = downloadTransactionsResponse.getError();
            TppMessageInformation tppMessage = error.getTppMessage();
            this.response.setStatus(error.getErrorType().getErrorCode());
            this.response.setContentType("application/json");
            this.flushResponseError(new TppErrorMessage(tppMessage.getCategory(), tppMessage.getMessageErrorCode(), tppMessage.getText()));
            return;
        }
        Xs2aTransactionsDownloadResponse responseBody = downloadTransactionsResponse.getBody();
        Integer dataSizeBytes = responseBody.getDataSizeBytes();
        String dataFileName = responseBody.getDataFileName();
        try (InputStream transactions = responseBody.getTransactionStream();){
            IOUtils.copy((InputStream)transactions, (OutputStream)this.response.getOutputStream(), (int)4096);
            this.response.setContentType("application/octet-stream");
            this.response.addHeader("Content-Disposition", this.resolveContentDisposition(dataFileName));
            if (dataSizeBytes != null) {
                this.response.setContentLength(dataSizeBytes.intValue());
            }
            this.response.flushBuffer();
        }
        catch (IOException e) {
            log.info("X-Request-ID: [{}], Consent-ID: [{}], Account-ID: [{}]. Download-ID [{}]. Download transactions failed: IOException occurred in downloadTransactions controller.", new Object[]{xRequestId, consentId, accountId, downloadId});
            this.response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            this.flushResponseError(new TppErrorMessage(MessageCategory.ERROR, MessageErrorCode.INTERNAL_SERVER_ERROR, "Internal Server Error"));
        }
    }

    public ResponseEntity getTransactionDetails(String accountId, String resourceId, UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Transactions> transactionDetails = this.transactionService.getTransactionDetails(consentID, accountId, resourceId, this.trimEndingSlash(this.request.getRequestURI()));
        return transactionDetails.hasError() ? this.responseErrorMapper.generateErrorResponse(transactionDetails.getError()) : this.responseMapper.ok(transactionDetails, this.accountModelMapper::mapToTransactionDetails);
    }

    private String trimEndingSlash(String input) {
        String result = input;
        while (StringUtils.endsWith((CharSequence)result, (CharSequence)"/")) {
            result = StringUtils.removeEnd((String)result, (String)"/");
        }
        return result;
    }

    private String resolveContentDisposition(String fileName) {
        return String.format("attachment; filename=%s", fileName == null ? Long.valueOf(System.currentTimeMillis()) : fileName);
    }

    private void flushResponseError(TppErrorMessage errorMessage) {
        try {
            this.response.getWriter().println(errorMessage.toString());
            this.response.flushBuffer();
        }
        catch (IOException e) {
            log.info(" Writing to the httpServletResponse failed.");
        }
    }

    @ConstructorProperties(value={"request", "response", "balanceService", "accountListService", "accountDetailsService", "transactionService", "responseMapper", "accountModelMapper", "responseErrorMapper"})
    public AccountController(HttpServletRequest request, HttpServletResponse response, BalanceService balanceService, AccountListService accountListService, AccountDetailsService accountDetailsService, TransactionService transactionService, ResponseMapper responseMapper, AccountModelMapper accountModelMapper, ResponseErrorMapper responseErrorMapper) {
        this.request = request;
        this.response = response;
        this.balanceService = balanceService;
        this.accountListService = accountListService;
        this.accountDetailsService = accountDetailsService;
        this.transactionService = transactionService;
        this.responseMapper = responseMapper;
        this.accountModelMapper = accountModelMapper;
        this.responseErrorMapper = responseErrorMapper;
    }
}

