/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.tpp;

import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoCheckerService;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class TppInfoValidator {
    private static final Logger log = LoggerFactory.getLogger(TppInfoValidator.class);
    static final String TPP_ERROR_MESSAGE = "TPP certificate doesn\u2019t match the initial request";
    private final TppInfoCheckerService tppInfoCheckerService;
    private final RequestProviderService requestProviderService;

    public ValidationResult validateTpp(@Nullable TppInfo tppInfo) {
        if (this.tppInfoCheckerService.differsFromTppInRequest(tppInfo)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. TPP validation has failed: TPP in consent/payment doesn't match the TPP in request", (Object)this.requestProviderService.getInternalRequestId(), (Object)this.requestProviderService.getRequestId());
            return ValidationResult.invalid(this.getErrorType(), this.getTppMessageInformation());
        }
        return ValidationResult.valid();
    }

    abstract ErrorType getErrorType();

    abstract TppMessageInformation getTppMessageInformation();

    @ConstructorProperties(value={"tppInfoCheckerService", "requestProviderService"})
    public TppInfoValidator(TppInfoCheckerService tppInfoCheckerService, RequestProviderService requestProviderService) {
        this.tppInfoCheckerService = tppInfoCheckerService;
        this.requestProviderService = requestProviderService;
    }
}

