/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.tpp;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PiisTppInfoValidator {
    private static final Logger log = LoggerFactory.getLogger(PiisTppInfoValidator.class);
    static final String TPP_ERROR_MESSAGE = "TPP certificate doesn\u2019t match the initial request";
    private final RequestProviderService requestProviderService;
    private final TppService tppService;

    public ValidationResult validateTpp(String authorisationNumber) {
        if (this.differsFromTppInRequest(authorisationNumber)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. TPP validation has failed: TPP in consent/payment doesn't match the TPP in request", (Object)this.requestProviderService.getInternalRequestId(), (Object)this.requestProviderService.getRequestId());
            return ValidationResult.invalid(ErrorType.PIIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400, TPP_ERROR_MESSAGE));
        }
        return ValidationResult.valid();
    }

    private boolean differsFromTppInRequest(String tppAuthorisationNumber) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber)) {
            return true;
        }
        TppInfo tppInRequest = this.tppService.getTppInfo();
        return !tppInRequest.getAuthorisationNumber().equals(tppAuthorisationNumber);
    }

    @ConstructorProperties(value={"requestProviderService", "tppService"})
    public PiisTppInfoValidator(RequestProviderService requestProviderService, TppService tppService) {
        this.requestProviderService = requestProviderService;
        this.tppService = tppService;
    }
}

