/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.payment;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.PsuDataInInitialRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.SupportedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.PaymentTypeAndProductValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.dto.CreatePaymentRequestObject;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreatePaymentValidator
implements BusinessValidator<CreatePaymentRequestObject> {
    private static final Logger log = LoggerFactory.getLogger(CreatePaymentValidator.class);
    private final PsuDataInInitialRequestValidator psuDataInInitialRequestValidator;
    private final SupportedAccountReferenceValidator supportedAccountReferenceValidator;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final PaymentTypeAndProductValidator paymentProductAndTypeValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull CreatePaymentRequestObject createPaymentRequestObject) {
        String paymentProduct;
        PaymentInitiationParameters paymentInitiationParameters = createPaymentRequestObject.getPaymentInitiationParameters();
        PaymentType paymentType = paymentInitiationParameters.getPaymentType();
        ValidationResult productAndTypeValidationResult = this.paymentProductAndTypeValidator.validateTypeAndProduct(paymentType, paymentProduct = paymentInitiationParameters.getPaymentProduct());
        if (productAndTypeValidationResult.isNotValid()) {
            return productAndTypeValidationResult;
        }
        ValidationResult psuDataValidationResult = this.psuDataInInitialRequestValidator.validate(paymentInitiationParameters.getPsuData());
        if (psuDataValidationResult.isNotValid()) {
            return psuDataValidationResult;
        }
        Set<AccountReference> accountReferences = this.extractAccountReferencesFromPayment(paymentProduct, paymentType, createPaymentRequestObject.getPayment());
        ValidationResult supportedAccountReferenceValidationResult = this.supportedAccountReferenceValidator.validate((Collection<AccountReference>)accountReferences);
        if (supportedAccountReferenceValidationResult.isNotValid()) {
            return supportedAccountReferenceValidationResult;
        }
        return ValidationResult.valid();
    }

    private Set<AccountReference> extractAccountReferencesFromPayment(String paymentProduct, PaymentType paymentType, Object payment) {
        CommonPayment paymentWithAccountReferences;
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(paymentProduct)) {
            return Collections.emptySet();
        }
        if (paymentType == PaymentType.SINGLE) {
            paymentWithAccountReferences = (SinglePayment)payment;
        } else if (paymentType == PaymentType.PERIODIC) {
            paymentWithAccountReferences = (PeriodicPayment)payment;
        } else if (paymentType == PaymentType.BULK) {
            paymentWithAccountReferences = (BulkPayment)payment;
        } else {
            log.error("Unknown payment type: {}", (Object)paymentType);
            throw new IllegalArgumentException("Unknown payment type");
        }
        return paymentWithAccountReferences.getAccountReferences();
    }

    @ConstructorProperties(value={"psuDataInInitialRequestValidator", "supportedAccountReferenceValidator", "standardPaymentProductsResolver", "paymentProductAndTypeValidator"})
    public CreatePaymentValidator(PsuDataInInitialRequestValidator psuDataInInitialRequestValidator, SupportedAccountReferenceValidator supportedAccountReferenceValidator, StandardPaymentProductsResolver standardPaymentProductsResolver, PaymentTypeAndProductValidator paymentProductAndTypeValidator) {
        this.psuDataInInitialRequestValidator = psuDataInInitialRequestValidator;
        this.supportedAccountReferenceValidator = supportedAccountReferenceValidator;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.paymentProductAndTypeValidator = paymentProductAndTypeValidator;
    }
}

