/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationStatusValidator;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PisAuthorisationValidator {
    private static final Logger log = LoggerFactory.getLogger(PisAuthorisationValidator.class);
    private final RequestProviderService requestProviderService;
    private final PisAuthorisationStatusValidator pisAuthorisationStatusValidator;

    @NotNull
    public ValidationResult validate(@NotNull String authorisationId, @NotNull PisCommonPaymentResponse commonPaymentResponse) {
        Optional<Authorisation> authorisationOptional = this.findAuthorisationInPayment(authorisationId, commonPaymentResponse);
        if (!authorisationOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}], Authorisation ID: [{}]. Updating PIS initiation authorisation PSU Data has failed: couldn't find authorisation with given authorisationId for payment", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), commonPaymentResponse.getExternalId(), authorisationId});
            return ValidationResult.invalid(ErrorType.PIS_403, MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        ValidationResult authorisationValidationResult = this.pisAuthorisationStatusValidator.validate(authorisationOptional.get().getScaStatus());
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        return ValidationResult.valid();
    }

    private Optional<Authorisation> findAuthorisationInPayment(String authorisationId, PisCommonPaymentResponse paymentResponse) {
        return paymentResponse.getAuthorisations().stream().filter(auth -> auth.getId().equals(authorisationId)).findFirst();
    }

    @ConstructorProperties(value={"requestProviderService", "pisAuthorisationStatusValidator"})
    public PisAuthorisationValidator(RequestProviderService requestProviderService, PisAuthorisationStatusValidator pisAuthorisationStatusValidator) {
        this.requestProviderService = requestProviderService;
        this.pisAuthorisationStatusValidator = pisAuthorisationStatusValidator;
    }
}

