/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AbstractConsentTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AisAuthorisationStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.UpdateConsentPsuDataRequestObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class UpdateConsentPsuDataValidator
extends AbstractConsentTppValidator<UpdateConsentPsuDataRequestObject> {
    private final AisAuthorisationStatusValidator aisAuthorisationStatusValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(UpdateConsentPsuDataRequestObject requestObject) {
        AccountConsentAuthorization authorisation = requestObject.getAuthorisation();
        ValidationResult authorisationValidationResult = this.aisAuthorisationStatusValidator.validate(authorisation.getScaStatus());
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"aisAuthorisationStatusValidator"})
    public UpdateConsentPsuDataValidator(AisAuthorisationStatusValidator aisAuthorisationStatusValidator) {
        this.aisAuthorisationStatusValidator = aisAuthorisationStatusValidator;
    }
}

