/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.ais.AccountResponseType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TransactionReportAcceptHeaderValidator {
    private final AspspProfileService aspspProfileService;

    public ValidationResult validate(String acceptHeader) {
        String supportedTransactionApplicationTypes;
        if (StringUtils.isNotBlank((CharSequence)acceptHeader) && !this.isAcceptHeaderSupported(supportedTransactionApplicationTypes = this.aspspProfileService.getAspspSettings().getSupportedTransactionApplicationTypes(), acceptHeader)) {
            return ValidationResult.invalid(ErrorType.AIS_406, TppMessageInformation.of(MessageErrorCode.REQUESTED_FORMATS_INVALID));
        }
        return ValidationResult.valid();
    }

    private boolean isAcceptHeaderSupported(String supportedHeader, String acceptHeader) {
        return AccountResponseType.fromValue((String)supportedHeader).getValue().equalsIgnoreCase(acceptHeader);
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public TransactionReportAcceptHeaderValidator(AspspProfileService aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

