/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiTransactionListToXs2aAccountReportMapper {
    private static final Predicate<SpiTransaction> BOOKED_PREDICATE = SpiTransaction::isBookedTransaction;
    private static final Predicate<SpiTransaction> PENDING_PREDICATE = SpiTransaction::isPendingTransaction;
    private final SpiToXs2aTransactionMapper toXs2aTransactionMapper;

    public Optional<Xs2aAccountReport> mapToXs2aAccountReport(BookingStatus queryStatus, List<SpiTransaction> spiTransactions, byte[] rawTransactionsResponse) {
        if (ArrayUtils.isNotEmpty((byte[])rawTransactionsResponse)) {
            return Optional.of(new Xs2aAccountReport(null, null, rawTransactionsResponse));
        }
        if (CollectionUtils.isEmpty(spiTransactions)) {
            return Optional.empty();
        }
        List<Transactions> booked = Collections.emptyList();
        List<Transactions> pending = Collections.emptyList();
        if (queryStatus != BookingStatus.PENDING) {
            booked = this.filterTransaction(spiTransactions, BOOKED_PREDICATE);
        }
        if (queryStatus != BookingStatus.BOOKED) {
            pending = this.filterTransaction(spiTransactions, PENDING_PREDICATE);
        }
        return Optional.of(new Xs2aAccountReport(booked, pending, null));
    }

    @NotNull
    private List<Transactions> filterTransaction(List<SpiTransaction> spiTransactions, Predicate<SpiTransaction> predicate) {
        return spiTransactions.stream().filter(predicate).map(this.toXs2aTransactionMapper::mapToXs2aTransaction).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"toXs2aTransactionMapper"})
    public SpiTransactionListToXs2aAccountReportMapper(SpiToXs2aTransactionMapper toXs2aTransactionMapper) {
        this.toXs2aTransactionMapper = toXs2aTransactionMapper;
    }
}

